"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.unassignedStyle = exports.unassignedChildrenStyle = exports.Unassigned = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _shard = require("./shard");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/components/elasticsearch/shard_allocation/components/unassigned.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const unassignedStyle = ({
  euiTheme
}) => (0, _react2.css)`
  vertical-align: middle;
  width: calc(${euiTheme.size.l} * 10);
`;
exports.unassignedStyle = unassignedStyle;
const unassignedChildrenStyle = ({
  euiTheme
}) => (0, _react2.css)`
  ${(0, _eui.logicalCSS)('padding-top', euiTheme.size.l)}
`;
exports.unassignedChildrenStyle = unassignedChildrenStyle;
class Unassigned extends _react.default.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "createShard", shard => {
      const type = shard.primary ? 'primary' : 'replica';
      const additionId = shard.state === 'UNASSIGNED' ? Math.random() : '';
      const key = shard.index + '.' + shard.node + '.' + type + '.' + shard.state + '.' + shard.shard + additionId;
      return /*#__PURE__*/_react.default.createElement(_shard.Shard, {
        shard: shard,
        key: key,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 47,
          columnNumber: 12
        }
      });
    });
  }
  render() {
    const shards = (0, _lodash.sortBy)(this.props.shards, 'shard').map(this.createShard);
    return /*#__PURE__*/_react.default.createElement("td", {
      css: unassignedStyle,
      "data-test-subj": "clusterView-Unassigned",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      wrap: true,
      css: unassignedChildrenStyle,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 9
      }
    }, shards));
  }
}
exports.Unassigned = Unassigned;
(0, _defineProperty2.default)(Unassigned, "displayName", _i18n.i18n.translate('xpack.monitoring.elasticsearch.shardAllocation.unassignedDisplayName', {
  defaultMessage: 'Unassigned'
}));