"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLastValue = getLastValue;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * @param {Array/Number} data Data containing values to show in the horizontal legend
 * @return {Number/Null} Value to use from the given data
 */
function getLastValue(data) {
  if ((0, _lodash.isNumber)(data)) {
    return data;
  }
  if (!Array.isArray(data)) {
    return null;
  }
  const lastValue = (0, _lodash.get)((0, _lodash.last)(data), '[1]');
  // check numeric to make sure 0 doesn't convert to null
  if ((0, _lodash.isNumber)(lastValue)) {
    return lastValue;
  }

  // undefined/null return as null to show as N/A
  return null;
}