"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SMALL_FLOAT = exports.SMALL_BYTES = exports.ROUNDED_FLOAT = exports.LARGE_FLOAT = exports.LARGE_BYTES = exports.LARGE_ABBREVIATED = exports.LARGE = void 0;
exports.formatDateTimeLocal = formatDateTimeLocal;
exports.getCalendar = getCalendar;
exports.getDateFromNow = getDateFromNow;
exports.shortenPipelineHash = shortenPipelineHash;
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LARGE_FLOAT = exports.LARGE_FLOAT = '0,0.[00]';
const SMALL_FLOAT = exports.SMALL_FLOAT = '0.[00]';
const LARGE_BYTES = exports.LARGE_BYTES = '0,0.0 b';
const SMALL_BYTES = exports.SMALL_BYTES = '0.0 b';
const LARGE_ABBREVIATED = exports.LARGE_ABBREVIATED = '0,0.[0]a';
const LARGE = exports.LARGE = '0,0';
const ROUNDED_FLOAT = exports.ROUNDED_FLOAT = '00.[00]';

/**
 * Format the {@code date} in the user's expected date/time format using their <em>guessed</em> local time zone.
 * @param date Either a numeric Unix timestamp or a {@code Date} object
 * @returns The date formatted using 'LL LTS'
 */
function formatDateTimeLocal(date, useUTC = false, timezone = null) {
  return useUTC ? _momentTimezone.default.utc(date).format('LL LTS') : _momentTimezone.default.tz(date, timezone || _momentTimezone.default.tz.guess()).format('LL LTS');
}

/**
 * Shorten a Logstash Pipeline's hash for display purposes
 * @param {string} hash The complete hash
 * @return {string} The shortened hash
 */
function shortenPipelineHash(hash) {
  return hash.substr(0, 6);
}
function getDateFromNow(timestamp, tz) {
  return (0, _momentTimezone.default)(timestamp).tz(tz === 'Browser' ? _momentTimezone.default.tz.guess() : tz).fromNow();
}
function getCalendar(timestamp, tz) {
  return (0, _momentTimezone.default)(timestamp).tz(tz === 'Browser' ? _momentTimezone.default.tz.guess() : tz).calendar();
}