"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitoringCollectionPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _metrics = require("@kbn/metrics");
var _routes = require("./routes");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class MonitoringCollectionPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "initializerContext", void 0);
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "metrics", {});
    (0, _defineProperty2.default)(this, "prometheusExporter", void 0);
    this.initializerContext = initializerContext;
    this.logger = initializerContext.logger.get();
    this.config = initializerContext.config.get();
  }
  async getMetric(type) {
    if (Object.hasOwn(this.metrics, type)) {
      return await this.metrics[type].fetch();
    }
    this.logger.warn(`Call to 'getMetric' failed because type '${type}' does not exist.`);
    return undefined;
  }
  setup(core) {
    var _this$config$opentele;
    const router = core.http.createRouter();
    const kibanaIndex = core.savedObjects.getDefaultIndex();
    const server = core.http.getServerInfo();
    const uuid = this.initializerContext.env.instanceUuid;
    const kibanaVersion = this.initializerContext.env.packageInfo.version;
    if ((_this$config$opentele = this.config.opentelemetry) !== null && _this$config$opentele !== void 0 && _this$config$opentele.metrics.prometheus.enabled) {
      // Add Prometheus exporter
      this.logger.debug(`Starting prometheus exporter at ${_routes.PROMETHEUS_PATH}`);
      this.prometheusExporter = _metrics.PrometheusExporter.get();
    }
    let status;
    core.status.overall$.subscribe(newStatus => {
      status = newStatus;
    });
    if (this.prometheusExporter) {
      (0, _routes.registerV1PrometheusRoute)({
        router,
        prometheusExporter: this.prometheusExporter
      });
    }
    (0, _routes.registerDynamicRoute)({
      router,
      config: {
        kibanaIndex,
        kibanaVersion,
        server,
        uuid
      },
      getStatus: () => status,
      getMetric: async type => {
        return await this.getMetric(type);
      }
    });
    return {
      registerMetric: metric => {
        if (Object.hasOwn(this.metrics, metric.type)) {
          this.logger.warn(`Skipping registration of metric type '${metric.type}'. This type has already been registered.`);
          return;
        }
        if (!_constants.TYPE_ALLOWLIST.includes(metric.type)) {
          this.logger.warn(`Skipping registration of metric type '${metric.type}'. This type is not supported in the allowlist.`);
          return;
        }
        this.metrics[metric.type] = metric;
      }
    };
  }
  start() {}
  stop() {}
}
exports.MonitoringCollectionPlugin = MonitoringCollectionPlugin;