"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ANTLRErrorListener = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _antlr = require("antlr4");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class ANTLRErrorListener extends _antlr.ErrorListener {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "errors", []);
  }
  syntaxError(recognizer, offendingSymbol, line, column, message, error) {
    let endColumn = column + 1;
    if (offendingSymbol !== null && offendingSymbol !== void 0 && offendingSymbol._text) {
      endColumn = column + offendingSymbol._text.length;
    }
    this.errors.push({
      startLineNumber: line,
      endLineNumber: line,
      startColumn: column,
      endColumn,
      message,
      severity: 8,
      code: 'syntaxError'
    });
  }
  getErrors() {
    return this.errors;
  }
}
exports.ANTLRErrorListener = ANTLRErrorListener;