"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OverviewTabContent = exports.LABELS = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _check_capabilities = require("../../capabilities/check_capabilities");
var _serverless_context = require("../../contexts/ml/serverless_context");
var _kibana = require("../../contexts/kibana");
var _flyout = require("./flyout");
var _data_views_table = require("./data_views_table");
var _supplied_configurations = require("../supplied_configurations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/supplied_configurations/supplied_configurations_flyout/overview_tab_content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LABELS = exports.LABELS = {
  dashboard: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.anomalyDetection.suppliedConfigurationsFlyout.dashboardLabel",
    defaultMessage: "Dashboard",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 5
    }
  }),
  jobs: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.anomalyDetection.suppliedConfigurationsFlyout.jobsLabel",
    defaultMessage: "Jobs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 5
    }
  }),
  search: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.anomalyDetection.suppliedConfigurationsFlyout.searchLabel",
    defaultMessage: "Search",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 5
    }
  }),
  visualization: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.anomalyDetection.suppliedConfigurationsFlyout.visualizationLabel",
    defaultMessage: "Visualization",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 5
    }
  })
};
const ListDescriptionItem = ({
  label,
  onClick,
  value
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 81,
    columnNumber: 5
  }
}, label ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
  color: 'text',
  onClick: onClick,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 83,
    columnNumber: 9
  }
}, LABELS[label]) : '', label ? ' ' : '', /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
  size: label ? 's' : 'm',
  color: "subdued",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 90,
    columnNumber: 7
  }
}, value)), label ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 94,
    columnNumber: 21
  }
}));
const OverviewTabContent = ({
  module,
  setSelectedTabId,
  setSelectedKibanaSubTab
}) => {
  var _module$tags;
  const [runningDataRecognizer, setRunningDataRecognizer] = (0, _react.useState)(false);
  const [recognizerWasRun, setRecognizerWasRun] = (0, _react.useState)(false);
  const [matchingDataViews, setMatchingDataViews] = (0, _react.useState)([]);
  const {
    services: {
      docLinks,
      mlServices: {
        mlApi: {
          recognizeModule
        }
      }
    }
  } = (0, _kibana.useMlKibana)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const logsConfigsUrl = docLinks.links.ml.logsAnomalyDetectionConfigs;
  const metricsConfigsUrl = docLinks.links.ml.metricsAnomalyDetectionConfigs;
  const canCreateJob = (0, _check_capabilities.usePermissionCheck)('canCreateJob');
  const {
    showLogsSuppliedConfigurationsInfo
  } = (0, _serverless_context.useEnabledFeatures)();
  const runDataRecongizer = async () => {
    setRunningDataRecognizer(true);
    const result = await recognizeModule({
      moduleId: module.id
    });
    setMatchingDataViews(result);
    setRunningDataRecognizer(false);
    setRecognizerWasRun(true);
  };
  const runRecognizerButton = /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    isDisabled: runningDataRecognizer || canCreateJob === false,
    isLoading: runningDataRecognizer,
    color: 'primary',
    onClick: runDataRecongizer,
    size: "s",
    "data-test-subj": "mlSuppliedConfigurationsFlyoutRunDataRecognizerButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.anomalyDetection.suppliedConfigurationsFlyout.runDataRecognizerButtonLabel",
    defaultMessage: "Run data recognizer",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 9
    }
  })));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      padding: `0 ${euiTheme.size.m}`
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 11
    }
  }, module.description))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      padding: `0 ${euiTheme.size.m}`
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    rowGutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.anomalyDetection.suppliedConfigurationsFlyout.assetsTitle",
    defaultMessage: "Assets",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(ListDescriptionItem, {
    label: "jobs",
    value: module.jobs.length,
    onClick: () => setSelectedTabId(_flyout.TAB_IDS.JOBS),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 15
    }
  }), module.kibana ? Object.keys(module.kibana).map(kibanaAsset => {
    var _ref, _module$kibana$kibana;
    return /*#__PURE__*/_react.default.createElement(ListDescriptionItem, {
      label: kibanaAsset,
      onClick: () => {
        setSelectedKibanaSubTab(kibanaAsset);
        setSelectedTabId(_flyout.TAB_IDS.KIBANA);
      },
      value: (_ref = module.kibana && ((_module$kibana$kibana = module.kibana[kibanaAsset]) === null || _module$kibana$kibana === void 0 ? void 0 : _module$kibana$kibana.length)) !== null && _ref !== void 0 ? _ref : 0,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 184,
        columnNumber: 23
      }
    });
  }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.anomalyDetection.suppliedConfigurationsFlyout.tagsTitle",
    defaultMessage: "Tags",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 15
    }
  }), (_module$tags = module.tags) !== null && _module$tags !== void 0 && _module$tags.length ? module.tags.map(tag => /*#__PURE__*/_react.default.createElement(ListDescriptionItem, {
    value: tag,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 42
    }
  })) : /*#__PURE__*/_react.default.createElement(ListDescriptionItem, {
    value: _i18n.i18n.translate('xpack.ml.anomalyDetection.suppliedConfigurationsFlyout.noTagsLabel', {
      defaultMessage: 'No tags'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.anomalyDetection.suppliedConfigurationsFlyout.typeTitle",
    defaultMessage: "Type",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 15
    }
  }, module.type))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 11
    }
  }, module.query !== undefined ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    rowGutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.anomalyDetection.suppliedConfigurationsFlyout.eligibleTitle",
    defaultMessage: "These jobs are available if data exists that match the following query:",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 237,
      columnNumber: 23
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 21
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    isCopyable: true,
    overflowHeight: "500px",
    "data-test-subj": "mlPreconfigJobsQueryBlock",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 244,
      columnNumber: 23
    }
  }, JSON.stringify(module.query, null, 2)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 23
    }
  })))), module.query !== undefined ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center",
    justifyContent: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 258,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 259,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: 'xs',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 260,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.anomalyDetection.suppliedConfigurationsFlyout.dataRecognizerHelpButtonLabel",
    defaultMessage: "Check data views to determine which can be used to create jobs with this configuration.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 261,
      columnNumber: 27
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 23
    }
  }, canCreateJob === false ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: (0, _check_capabilities.createPermissionFailureMessage)('canCreateJob'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 269,
      columnNumber: 27
    }
  }, runRecognizerButton) : runRecognizerButton))) : null, recognizerWasRun ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 283,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_data_views_table.DataViewsTable, {
    matchingDataViews: matchingDataViews,
    moduleId: module.id,
    jobsLength: module.jobs.length,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 284,
      columnNumber: 21
    }
  })) : null) : /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    css: {
      margin: euiTheme.size.s
    },
    color: "primary",
    iconType: (0, _supplied_configurations.isLogoObject)(module.logo) ? module.logo.icon : undefined,
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 298,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.anomalyDetection.suppliedConfigurationsFlyout.unableToUseModuleTitle",
      defaultMessage: "You cannot create these jobs here",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 299,
        columnNumber: 21
      }
    })),
    body: showLogsSuppliedConfigurationsInfo === true ? /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 307,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.anomalyDetection.suppliedConfigurationsFlyout.unableToUseModuleHelpMessage",
      defaultMessage: "These supplied configurations can be used in {appName}.",
      values: {
        appName: module.type
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 308,
        columnNumber: 23
      }
    })) : undefined,
    footer: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 318,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 319,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.anomalyDetection.suppliedConfigurationsFlyout.useInanotherAppTitle",
      defaultMessage: "Want to learn more?",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 320,
        columnNumber: 25
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: module.type === 'Logs' ? logsConfigsUrl : metricsConfigsUrl,
      target: "_blank",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 326,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.anomalyDetection.suppliedConfigurationsFlyout.useInanotherAppLink",
      defaultMessage: "Refer to the docs for more information on how to use this supplied configuration in other apps",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 330,
        columnNumber: 23
      }
    }))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 293,
      columnNumber: 15
    }
  })))));
};
exports.OverviewTabContent = OverviewTabContent;