"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterListsTable = FilterListsTable;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _delete_filter_list_modal = require("../components/delete_filter_list_modal");
var _use_create_url = require("../../../contexts/kibana/use_create_url");
var _locator = require("../../../../../common/constants/locator");
var _management = require("../../../management");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/settings/filter_lists/list/table.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
 * React table for displaying a table of filter lists.
 */
function UsedByIcon({
  usedBy
}) {
  // Renders a tick or cross in the 'usedBy' column to indicate whether
  // the filter list is in use in a detectors in any jobs.
  let icon;
  if (usedBy !== undefined && usedBy.jobs.length > 0) {
    icon = /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "check",
      "aria-label": _i18n.i18n.translate('xpack.ml.settings.filterLists.table.inUseAriaLabel', {
        defaultMessage: 'In use'
      }),
      "data-test-subj": "mlFilterListUsedByIcon inUse",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 7
      }
    });
  } else {
    icon = /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "cross",
      "aria-label": _i18n.i18n.translate('xpack.ml.settings.filterLists.table.notInUseAriaLabel', {
        defaultMessage: 'Not in use'
      }),
      "data-test-subj": "mlFilterListUsedByIcon notInUse",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 7
      }
    });
  }
  return icon;
}
UsedByIcon.propTypes = {
  usedBy: _propTypes.default.object
};
function NewFilterButton({
  canCreateFilter
}) {
  const redirectToNewFilterListPage = (0, _use_create_url.useCreateAndNavigateToManagementMlLink)(_locator.ML_PAGES.FILTER_LISTS_NEW, _management.MANAGEMENT_SECTION_IDS.AD_SETTINGS);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    key: "new_filter_list",
    onClick: redirectToNewFilterListPage,
    isDisabled: canCreateFilter === false,
    "data-test-subj": "mlFilterListsButtonCreate",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.settings.filterLists.table.newButtonLabel",
    defaultMessage: "New",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }));
}
function getColumns() {
  const columns = [{
    field: 'filter_id',
    name: _i18n.i18n.translate('xpack.ml.settings.filterLists.table.idColumnName', {
      defaultMessage: 'ID'
    }),
    render: id => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Link, {
      to: `/${_locator.ML_PAGES.FILTER_LISTS_EDIT}/${id}`,
      "data-test-subj": "mlEditFilterListLink",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 9
      }
    }, id),
    sortable: true,
    scope: 'row',
    'data-test-subj': 'mlFilterListColumnId'
  }, {
    field: 'description',
    name: _i18n.i18n.translate('xpack.ml.settings.filterLists.table.descriptionColumnName', {
      defaultMessage: 'Description'
    }),
    sortable: true,
    'data-test-subj': 'mlFilterListColumnDescription'
  }, {
    field: 'item_count',
    name: _i18n.i18n.translate('xpack.ml.settings.filterLists.table.itemCountColumnName', {
      defaultMessage: 'Item count'
    }),
    sortable: true,
    'data-test-subj': 'mlFilterListColumnItemCount'
  }, {
    field: 'used_by',
    name: _i18n.i18n.translate('xpack.ml.settings.filterLists.table.inUseColumnName', {
      defaultMessage: 'In use'
    }),
    render: usedBy => /*#__PURE__*/_react.default.createElement(UsedByIcon, {
      usedBy: usedBy,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 27
      }
    }),
    sortable: true,
    'data-test-subj': 'mlFilterListColumnInUse'
  }];
  return columns;
}
function renderToolsRight(canCreateFilter, canDeleteFilter, selectedFilterLists, refreshFilterLists) {
  return [/*#__PURE__*/_react.default.createElement(NewFilterButton, {
    key: "new_filter_list",
    canCreateFilter: canCreateFilter,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_delete_filter_list_modal.DeleteFilterListModal, {
    key: "delete_filter_list",
    canDeleteFilter: canDeleteFilter,
    selectedFilterLists: selectedFilterLists,
    refreshFilterLists: refreshFilterLists,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 5
    }
  })];
}
function FilterListsTable({
  canCreateFilter,
  canDeleteFilter,
  filterLists,
  selectedFilterLists,
  setSelectedFilterLists,
  refreshFilterLists
}) {
  const sorting = {
    sort: {
      field: 'filter_id',
      direction: 'asc'
    }
  };
  const search = {
    toolsRight: renderToolsRight(canCreateFilter, canDeleteFilter, selectedFilterLists, refreshFilterLists),
    box: {
      incremental: true
    },
    filters: []
  };
  const tableSelection = {
    selectable: filterList => filterList.used_by === undefined || filterList.used_by.jobs.length === 0,
    selectableMessage: () => undefined,
    onSelectionChange: selection => setSelectedFilterLists(selection)
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 5
    }
  }, filterLists === undefined || filterLists.length === 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexEnd",
    justifyContent: "flexEnd",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(NewFilterButton, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceAround",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.settings.filterLists.table.noFiltersCreatedTitle",
    defaultMessage: "No filters have been created",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 19
    }
  })))))) : /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "mlFilterListTableContainer",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    className: "ml-filter-lists-table",
    items: filterLists,
    itemId: "filter_id",
    columns: getColumns(),
    search: search,
    pagination: true,
    sorting: sorting,
    selection: tableSelection,
    "data-test-subj": "mlFilterListsTable",
    rowProps: item => ({
      'data-test-subj': `mlFilterListRow row-${item.filter_id}`
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 11
    }
  })));
}
FilterListsTable.propTypes = {
  canCreateFilter: _propTypes.default.bool.isRequired,
  canDeleteFilter: _propTypes.default.bool.isRequired,
  filterLists: _propTypes.default.array,
  selectedFilterLists: _propTypes.default.array,
  setSelectedFilterLists: _propTypes.default.func.isRequired,
  refreshFilterLists: _propTypes.default.func.isRequired
};
UsedByIcon.displayName = 'UsedByIcon';