"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TelemetryClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class TelemetryClient {
  constructor(analytics) {
    (0, _defineProperty2.default)(this, "trackTrainedModelsDeploymentCreated", eventProps => {
      this.analytics.reportEvent(_types.TrainedModelsTelemetryEventTypes.DEPLOYMENT_CREATED, eventProps);
    });
    (0, _defineProperty2.default)(this, "trackTrainedModelsModelDownload", eventProps => {
      this.analytics.reportEvent(_types.TrainedModelsTelemetryEventTypes.MODEL_DOWNLOAD, eventProps);
    });
    (0, _defineProperty2.default)(this, "trackTrainedModelsDeploymentUpdated", eventProps => {
      this.analytics.reportEvent(_types.TrainedModelsTelemetryEventTypes.DEPLOYMENT_UPDATED, eventProps);
    });
    (0, _defineProperty2.default)(this, "trackTrainedModelsModelTested", eventProps => {
      this.analytics.reportEvent(_types.TrainedModelsTelemetryEventTypes.MODEL_TESTED, eventProps);
    });
    this.analytics = analytics;
  }
}
exports.TelemetryClient = TelemetryClient;