"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.managementApiProvider = managementApiProvider;
exports.useManagementApiService = useManagementApiService;
var _react = require("react");
var _app = require("../../../../common/constants/app");
var _kibana = require("../../contexts/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Service with APIs calls to perform inference operations.
 * @param httpService
 */
function managementApiProvider(httpService) {
  return {
    /**
     * Fetches lists of anomaly detection jobs, data frame analytics jobs or trained models
     * for use in the stack management space management table.
     *
     * @param mlSavedObjectType - 'anomaly-detector', 'data-frame-analytics' or 'trained-model'
     */
    getList(mlSavedObjectType) {
      return httpService.http({
        path: `${_app.ML_INTERNAL_BASE_PATH}/management/list/${mlSavedObjectType}`,
        method: 'GET',
        version: '1'
      });
    }
  };
}
/**
 * Hooks for accessing {@link ManagementApiService} in React components.
 */
function useManagementApiService() {
  const {
    services: {
      mlServices: {
        httpService
      }
    }
  } = (0, _kibana.useMlKibana)();
  return (0, _react.useMemo)(() => managementApiProvider(httpService), [httpService]);
}