"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalyDetectorService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _ml_api_service = require("./ml_api_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class AnomalyDetectorService {
  constructor(httpService) {
    (0, _defineProperty2.default)(this, "mlApi", void 0);
    this.mlApi = (0, _ml_api_service.mlApiProvider)(httpService);
  }

  /**
   * Fetches a single job object
   * @param jobId
   */
  getJobById$(jobId) {
    return this.getJobs$([jobId]).pipe((0, _rxjs.map)(jobs => jobs[0]));
  }

  /**
   * Fetches anomaly detection jobs by ids
   * @param jobIds
   */
  getJobs$(jobIds) {
    return this.mlApi.getJobs$({
      jobId: jobIds.join(',')
    }).pipe((0, _rxjs.map)(response => response.jobs));
  }
}
exports.AnomalyDetectorService = AnomalyDetectorService;