"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyticsTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _mlDateUtils = require("@kbn/ml-date-utils");
var _mlDataFrameAnalyticsUtils = require("@kbn/ml-data-frame-analytics-utils");
var _common = require("../../../data_frame_analytics/pages/analytics_management/components/analytics_list/common");
var _use_columns = require("../../../data_frame_analytics/pages/analytics_management/components/analytics_list/use_columns");
var _actions = require("./actions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/overview/components/analytics_panel/table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AnalyticsTable = ({
  items
}) => {
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const [pageSize, setPageSize] = (0, _react.useState)(10);
  const [sortField, setSortField] = (0, _react.useState)(_common.DataFrameAnalyticsListColumn.id);
  const [sortDirection, setSortDirection] = (0, _react.useState)('asc');
  const columns = [{
    field: _common.DataFrameAnalyticsListColumn.id,
    name: _i18n.i18n.translate('xpack.ml.overview.analyticsList.id', {
      defaultMessage: 'ID'
    }),
    sortable: true,
    truncateText: false,
    width: '20%'
  }, {
    name: _i18n.i18n.translate('xpack.ml.overview.analyticsList.type', {
      defaultMessage: 'Type'
    }),
    sortable: item => (0, _mlDataFrameAnalyticsUtils.getAnalysisType)(item.config.analysis),
    truncateText: true,
    render(item) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 47,
          columnNumber: 16
        }
      }, (0, _mlDataFrameAnalyticsUtils.getAnalysisType)(item.config.analysis));
    },
    width: '150px'
  }, {
    name: _i18n.i18n.translate('xpack.ml.overview.analyticsList.status', {
      defaultMessage: 'Status'
    }),
    sortable: item => item.stats.state,
    truncateText: true,
    render(item) {
      return (0, _use_columns.getTaskStateBadge)(item.stats.state, item.stats.failure_reason);
    },
    width: '100px'
  }, _use_columns.progressColumn, {
    field: _common.DataFrameAnalyticsListColumn.configCreateTime,
    name: _i18n.i18n.translate('xpack.ml.overview.analyticsList.reatedTimeColumnName', {
      defaultMessage: 'Creation time'
    }),
    dataType: 'date',
    render: time => (0, _mlDateUtils.formatHumanReadableDateTime)(time),
    textOnly: true,
    truncateText: true,
    sortable: true,
    width: '25%'
  }, {
    name: _i18n.i18n.translate('xpack.ml.overview.analyticsList.tableActionLabel', {
      defaultMessage: 'Actions'
    }),
    actions: (0, _actions.useTableActions)(),
    width: '80px'
  }];
  const onTableChange = ({
    page = {
      index: 0,
      size: 10
    },
    sort = {
      field: _common.DataFrameAnalyticsListColumn.id,
      direction: 'asc'
    }
  }) => {
    const {
      index,
      size
    } = page;
    setPageIndex(index);
    setPageSize(size);
    const {
      field,
      direction
    } = sort;
    setSortField(field);
    setSortDirection(direction);
  };
  const pagination = {
    initialPageIndex: pageIndex,
    initialPageSize: pageSize,
    totalItemCount: items.length,
    pageSizeOptions: [10, 20, 50],
    showPerPageOptions: true
  };
  const sorting = {
    sort: {
      field: sortField,
      direction: sortDirection
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    allowNeutralSort: false,
    columns: columns,
    items: items,
    itemId: _common.DataFrameAnalyticsListColumn.id,
    onTableChange: onTableChange,
    pagination: pagination,
    sorting: sorting,
    "data-test-subj": "mlOverviewTableAnalytics",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 5
    }
  });
};
exports.AnalyticsTable = AnalyticsTable;