"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobsListPage = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _space_management_context_wrapper = require("../../../../components/space_management_context_wrapper");
var _upgrade_warning = require("../../../../components/upgrade/upgrade_warning");
var _get_services = require("../../../../util/get_services");
var _ml = require("../../../../contexts/ml");
var _app = require("../../../../../../common/constants/app");
var _check_capabilities = require("../../../../capabilities/check_capabilities");
var _access_denied_page = require("../access_denied_page");
var _insufficient_license_page = require("../insufficient_license_page");
var _job_spaces_sync = require("../../../../components/job_spaces_sync");
var _import_export_jobs = require("../../../../components/import_export_jobs");
var _space_management = require("./space_management");
var _docs_link = require("./docs_link");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/management/jobs_list/components/jobs_list_page/jobs_list_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const JobsListPage = ({
  coreStart,
  share,
  history,
  spaces,
  data,
  usageCollection,
  fieldFormats,
  isServerless,
  mlFeatures
}) => {
  const [initialized, setInitialized] = (0, _react.useState)(false);
  const [accessDenied, setAccessDenied] = (0, _react.useState)(false);
  const [isUpgradeInProgress, setIsUpgradeInProgress] = (0, _react.useState)(false);
  const [isPlatinumOrTrialLicense, setIsPlatinumOrTrialLicense] = (0, _react.useState)(true);
  const [showSyncFlyout, setShowSyncFlyout] = (0, _react.useState)(false);
  const [currentTabId, setCurrentTabId] = (0, _react.useState)('anomaly-detector');
  // callback to allow import flyout to refresh jobs list
  const [refreshJobs, setRefreshJobs] = (0, _react.useState)(null);
  const mlServices = (0, _react.useMemo)(() => (0, _get_services.getMlGlobalServices)(coreStart, data.dataViews, usageCollection), [coreStart, data.dataViews, usageCollection]);
  const check = async () => {
    try {
      await (0, _check_capabilities.checkGetManagementMlJobsResolver)(mlServices);
    } catch (e) {
      if (e.mlFeatureEnabledInSpace && e.isPlatinumOrTrialLicense === false) {
        setIsPlatinumOrTrialLicense(false);
      } else if (e.isUpgradeInProgress) {
        setIsUpgradeInProgress(true);
      } else {
        setAccessDenied(true);
      }
    }
    setInitialized(true);
  };
  const [canCreateJob] = (0, _check_capabilities.usePermissionCheck)(['canCreateJob']);
  (0, _react.useEffect)(() => {
    check();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  if (initialized === false) {
    return null;
  }
  function onCloseSyncFlyout() {
    if (typeof refreshJobs === 'function') {
      refreshJobs();
    }
    setShowSyncFlyout(false);
  }
  if (isUpgradeInProgress) {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 122,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, coreStart, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 123,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
      services: {
        ...coreStart,
        share,
        data,
        usageCollection,
        fieldFormats,
        spaces,
        mlServices
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_upgrade_warning.UpgradeWarning, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 135,
        columnNumber: 13
      }
    }))));
  }
  if (accessDenied) {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 144,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, coreStart, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_access_denied_page.AccessDeniedPage, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 146,
        columnNumber: 11
      }
    })));
  }
  if (isPlatinumOrTrialLicense === false) {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 154,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, coreStart, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_insufficient_license_page.InsufficientLicensePage, {
      basePath: coreStart.http.basePath,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 11
      }
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, coreStart, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
    coreStart: {
      application: coreStart.application
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: {
      ...coreStart,
      share,
      data,
      usageCollection,
      fieldFormats,
      spaces,
      mlServices
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_space_management_context_wrapper.SpaceManagementContextWrapper, {
    feature: _app.PLUGIN_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_ml.EnabledFeaturesContextProvider, {
    isServerless: isServerless,
    mlFeatures: mlFeatures,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: history,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Header, {
    pageTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.management.jobsList.jobsListTitle",
      defaultMessage: "Machine Learning",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 186,
        columnNumber: 23
      }
    }),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.management.jobsList.jobsListTagline",
      defaultMessage: "Identify, analyze, and process your data using advanced analysis techniques.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 192,
        columnNumber: 23
      }
    }),
    rightSideItems: [/*#__PURE__*/_react.default.createElement(_docs_link.DocsLink, {
      currentTabId: currentTabId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 197,
        columnNumber: 38
      }
    })],
    bottomBorder: true,
    paddingSize: 'none',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
    paddingSize: 'none',
    id: "kibanaManagementMLSection",
    "data-test-subj": "mlPageStackManagementJobsList",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    disabled: !canCreateJob,
    onClick: () => setShowSyncFlyout(true),
    "data-test-subj": "mlStackMgmtSyncButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 29
    }
  }, _i18n.i18n.translate('xpack.ml.management.jobsList.syncFlyoutButton', {
    defaultMessage: 'Synchronize saved objects'
  })), showSyncFlyout && /*#__PURE__*/_react.default.createElement(_job_spaces_sync.JobSpacesSyncFlyout, {
    onClose: onCloseSyncFlyout,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 48
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 29
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_import_export_jobs.ExportJobsFlyout, {
    isDisabled: !canCreateJob,
    currentTab: currentTabId === 'trained-model' ? 'anomaly-detector' : currentTabId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 25
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_import_export_jobs.ImportJobsFlyout, {
    isDisabled: !canCreateJob,
    onImportComplete: refreshJobs,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 25
    }
  }))), /*#__PURE__*/_react.default.createElement(_space_management.SpaceManagement, {
    spacesApi: spaces,
    onTabChange: setCurrentTabId,
    onReload: setRefreshJobs,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 21
    }
  })))))))));
};
exports.JobsListPage = JobsListPage;