"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CloseJobsConfirmModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _kibana = require("../../../../contexts/kibana");
var _jobs_utils = require("../../../jobs_utils");
var _utils = require("../utils");
var _managed_jobs_warning_callout = require("./managed_jobs_warning_callout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/jobs_list/components/confirm_modals/close_jobs_confirm_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CloseJobsConfirmModal = ({
  setShowFunction,
  unsetShowFunction,
  refreshJobs
}) => {
  const {
    services: {
      notifications: {
        toasts
      }
    }
  } = (0, _kibana.useMlKibana)();
  const mlApi = (0, _kibana.useMlApi)();
  const [modalVisible, setModalVisible] = (0, _react.useState)(false);
  const [hasManagedJob, setHasManaged] = (0, _react.useState)(true);
  const [jobsToReset, setJobsToReset] = (0, _react.useState)([]);
  const jobIds = (0, _react.useMemo)(() => jobsToReset.map(({
    id
  }) => id), [jobsToReset]);
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  (0, _react.useEffect)(() => {
    if (typeof setShowFunction === 'function') {
      setShowFunction(showModal);
    }
    return () => {
      if (typeof unsetShowFunction === 'function') {
        unsetShowFunction();
      }
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const showModal = (0, _react.useCallback)(jobs => {
    setJobsToReset(jobs);
    if (jobs.some(j => (0, _jobs_utils.isManagedJob)(j))) {
      setModalVisible(true);
      setHasManaged(true);
    }
  }, []);
  const closeModal = (0, _react.useCallback)(() => {
    setModalVisible(false);
    setHasManaged(false);
  }, []);
  if (modalVisible === false) {
    return null;
  }
  if (hasManagedJob) {
    const title = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobsList.startDatafeedsModal.closeDatafeedsTitle",
      defaultMessage: "Close {jobsCount, plural, one {{jobId}} other {# jobs}}?",
      values: {
        jobsCount: jobIds.length,
        jobId: jobIds[0]
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 7
      }
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
      "data-test-subj": "mlCloseJobsConfirmModal",
      onClose: closeModal,
      "aria-labelledby": modalTitleId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
      id: modalTitleId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 11
      }
    }, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_managed_jobs_warning_callout.ManagedJobsWarningCallout, {
      jobsCount: jobIds.length,
      action: _i18n.i18n.translate('xpack.ml.jobsList.closeJobsModal.closeManagedDatafeedsDescription', {
        defaultMessage: 'closing'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: closeModal,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobsList.startDatafeedsConfirmModal.cancelButtonLabel",
      defaultMessage: "Cancel",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 122,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: () => {
        (0, _utils.closeJobs)(toasts, mlApi, jobsToReset, refreshJobs);
        closeModal();
      },
      fill: true,
      color: "danger",
      "data-test-subj": "mlCloseJobsConfirmModalButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobsList.startDatafeedsConfirmModal.closeButtonLabel",
      defaultMessage: "Close {jobsCount, plural, one {job} other {jobs}}",
      values: {
        jobsCount: jobIds.length
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 15
      }
    })))));
  } else {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }
};
exports.CloseJobsConfirmModal = CloseJobsConfirmModal;