"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAlertsSummary = getAlertsSummary;
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getAlertsSummary(alertsData) {
  var _groupBy;
  return Object.entries((_groupBy = (0, _lodash.groupBy)(alertsData, _ruleDataUtils.ALERT_RULE_NAME)) !== null && _groupBy !== void 0 ? _groupBy : []).map(([ruleName, alerts]) => {
    // Find the latest alert for each rule
    const latestAlert = alerts.reduce((latest, alert) => {
      return alert[_ruleDataUtils.ALERT_START] > latest[_ruleDataUtils.ALERT_START] ? alert : latest;
    });
    return [ruleName, {
      totalCount: alerts.length,
      activeCount: alerts.filter(alert => alert[_ruleDataUtils.ALERT_STATUS] === _ruleDataUtils.ALERT_STATUS_ACTIVE).length,
      recoveredAt: latestAlert[_ruleDataUtils.ALERT_END],
      startedAt: latestAlert[_ruleDataUtils.ALERT_START],
      lastDuration: latestAlert[_ruleDataUtils.ALERT_DURATION]
    }];
  }).sort(([, alertsA], [, alertsB]) => {
    // 1. Prioritize rules with the highest number of active alerts
    if (alertsA.activeCount > alertsB.activeCount) return -1;
    if (alertsA.activeCount < alertsB.activeCount) return 1;
    // 2. Prioritize rules with the highest number of alerts in general
    if (alertsA.totalCount > alertsB.totalCount) return -1;
    if (alertsA.totalCount < alertsB.totalCount) return 1;
    // 3. At last prioritize rules with the longest duration
    if (alertsA.lastDuration > alertsB.lastDuration) return -1;
    if (alertsA.lastDuration < alertsB.lastDuration) return 1;
    return 0;
  });
}