"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.filterAnalytics = filterAnalytics;
var _string_utils = require("../../util/string_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function filterAnalytics(items, clauses) {
  if (clauses.length === 0) {
    return items;
  }

  // keep count of the number of matches we make as we're looping over the clauses
  // we only want to return items which match all clauses, i.e. each search term is ANDed
  const matches = items.reduce((p, c) => {
    p[c.id] = {
      job: c,
      count: 0
    };
    return p;
  }, {});
  clauses.forEach(c => {
    // the search term could be negated with a minus, e.g. -bananas
    const bool = c.match === 'must';
    let js = [];
    if (c.type === 'term') {
      // filter term based clauses, e.g. bananas
      // match on id, description and memory_status
      // if the term has been negated, AND the matches
      if (bool === true) {
        js = items.filter(item => {
          var _item$stats, _item$stats$memory_us;
          return (0, _string_utils.stringMatch)(item.id, c.value) === bool || (0, _string_utils.stringMatch)(item.config.description, c.value) === bool || (0, _string_utils.stringMatch)((_item$stats = item.stats) === null || _item$stats === void 0 ? void 0 : (_item$stats$memory_us = _item$stats.memory_usage) === null || _item$stats$memory_us === void 0 ? void 0 : _item$stats$memory_us.status, c.value) === bool;
        });
      } else {
        js = items.filter(item => {
          var _item$stats2, _item$stats2$memory_u;
          return (0, _string_utils.stringMatch)(item.id, c.value) === bool && (0, _string_utils.stringMatch)(item.config.description, c.value) === bool && (0, _string_utils.stringMatch)((_item$stats2 = item.stats) === null || _item$stats2 === void 0 ? void 0 : (_item$stats2$memory_u = _item$stats2.memory_usage) === null || _item$stats2$memory_u === void 0 ? void 0 : _item$stats2$memory_u.status, c.value) === bool;
        });
      }
    } else {
      // filter other clauses, i.e. the filters for type and status
      if (Array.isArray(c.value)) {
        // job type value and status value are an array of string(s) e.g. c.value => ['failed', 'stopped']
        js = items.filter(item => c.value.includes(item[c.field]));
      } else {
        js = items.filter(item => item[c.field] === c.value);
      }
    }
    js.forEach(j => matches[j.id].count++);
  });

  // loop through the matches and return only those items which have match all the clauses
  const filtered = Object.values(matches).filter(m => (m && m.count) >= clauses.length).map(m => m.job);
  return filtered;
}