"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectRuleAction = SelectRuleAction;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _detector_description_list = require("../components/detector_description_list");
var _rule_action_panel = require("./rule_action_panel");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/rule_editor/select_rule_action/select_rule_action.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
 * React component for selecting the rule to edit, create or delete.
 */
function SelectRuleAction({
  job,
  anomaly,
  setEditRuleIndex,
  updateRuleAtIndex,
  deleteRuleAtIndex,
  addItemToFilterList
}) {
  const detectorIndex = anomaly.detectorIndex;
  const detector = job.analysis_config.detectors[detectorIndex];
  const rules = detector.custom_rules || [];
  let ruleActionPanels;
  if (rules.length > 0) {
    ruleActionPanels = rules.map((rule, index) => {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
        key: `rule_panel_${index}_${rules.length}`,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 36,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_rule_action_panel.RuleActionPanel, {
        job: job,
        ruleIndex: index,
        anomaly: anomaly,
        setEditRuleIndex: setEditRuleIndex,
        updateRuleAtIndex: updateRuleAtIndex,
        deleteRuleAtIndex: deleteRuleAtIndex,
        addItemToFilterList: addItemToFilterList,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 37,
          columnNumber: 11
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "l",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 46,
          columnNumber: 11
        }
      }));
    });
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 5
    }
  }, rules.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_detector_description_list.DetectorDescriptionList, {
    job: job,
    detector: detector,
    anomaly: anomaly,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 11
    }
  }), ruleActionPanels, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    style: {
      display: 'inline'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.ruleEditor.selectRuleAction.orText",
    defaultMessage: "Or\xA0",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => setEditRuleIndex(rules.length),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.ruleEditor.selectRuleAction.createRuleLinkText",
    defaultMessage: "create a rule",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 9
    }
  })));
}
SelectRuleAction.propTypes = {
  job: _propTypes.default.object.isRequired,
  anomaly: _propTypes.default.object.isRequired,
  setEditRuleIndex: _propTypes.default.func.isRequired,
  updateRuleAtIndex: _propTypes.default.func.isRequired,
  deleteRuleAtIndex: _propTypes.default.func.isRequired,
  addItemToFilterList: _propTypes.default.func.isRequired
};