"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getModelType = exports.getInitialState = exports.getDefaultOnFailureConfiguration = void 0;
var _mlDataFrameAnalyticsUtils = require("@kbn/ml-data-frame-analytics-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getModelType = model => {
  var _model$metadata, _model$metadata$analy;
  const analysisConfig = (_model$metadata = model.metadata) === null || _model$metadata === void 0 ? void 0 : (_model$metadata$analy = _model$metadata.analytics_config) === null || _model$metadata$analy === void 0 ? void 0 : _model$metadata$analy.analysis;
  return analysisConfig !== undefined ? (0, _mlDataFrameAnalyticsUtils.getAnalysisType)(analysisConfig) : undefined;
};
exports.getModelType = getModelType;
const getDefaultOnFailureConfiguration = () => [{
  set: {
    description: "Index document to 'failed-<index>'",
    field: '_index',
    value: 'failed-{{{ _index }}}'
  }
}, {
  set: {
    field: 'event.timestamp',
    value: '{{{ _ingest.timestamp }}}'
  }
}, {
  set: {
    field: 'event.failure.message',
    value: '{{{ _ingest.on_failure_message }}}'
  }
}, {
  set: {
    field: 'event.failure.processor_type',
    value: '{{{ _ingest.on_failure_processor_type }}}'
  }
}, {
  set: {
    field: 'event.failure.processor_tag',
    value: '{{{ _ingest.on_failure_processor_tag }}}'
  }
}, {
  set: {
    field: 'event.failure.pipeline',
    value: '{{{ _ingest.on_failure_pipeline }}}'
  }
}];
exports.getDefaultOnFailureConfiguration = getDefaultOnFailureConfiguration;
const getInitialState = model => {
  var _targetField;
  const modelType = getModelType(model);
  let targetField;
  if (modelType !== undefined) {
    targetField = model.inference_config ? `ml.inference.${model.inference_config[modelType].results_field}` : undefined;
  }
  return {
    condition: undefined,
    creatingPipeline: false,
    error: false,
    fieldMap: undefined,
    ignoreFailure: false,
    inferenceConfig: model.inference_config,
    modelId: model.model_id,
    onFailure: getDefaultOnFailureConfiguration(),
    pipelineDescription: `Uses the pre-trained data frame analytics model ${model.model_id} to infer against the data that is being ingested in the pipeline`,
    pipelineName: `ml-inference-${model.model_id}`,
    pipelineCreated: false,
    tag: undefined,
    takeActionOnFailure: true,
    targetField: (_targetField = targetField) !== null && _targetField !== void 0 ? _targetField : ''
  };
};
exports.getInitialState = getInitialState;