"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _states = require("../../../../../common/constants/states");
var _ml_api_service = require("../../../services/ml_api_service");
var _http_service = require("../../../services/http_service");
var _ml_server_info = require("../../../services/ml_server_info");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/jobs_awaiting_node_warning/new_job_awaiting_node_shared/new_job_awaiting_node_shared.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function isJobAwaitingNodeAssignment(job) {
  return job.node === undefined && job.state === _states.JOB_STATE.OPENING;
}
const MLJobsAwaitingNodeWarning = ({
  jobIds
}) => {
  const {
    http
  } = (0, _public.useKibana)().services;
  const mlApi = (0, _react.useMemo)(() => (0, _ml_api_service.mlApiProvider)(new _http_service.HttpService(http)), [http]);
  const [unassignedJobCount, setUnassignedJobCount] = (0, _react.useState)(0);
  const [cloudInfo, setCloudInfo] = (0, _react.useState)(null);
  const [showNodeInfo, setShowNodeInfo] = (0, _react.useState)(false);
  const checkNodes = (0, _react.useCallback)(async () => {
    try {
      if (jobIds.length === 0) {
        setUnassignedJobCount(0);
        return;
      }
      const {
        lazyNodeCount
      } = await mlApi.mlNodeCount();
      if (lazyNodeCount === 0) {
        setUnassignedJobCount(0);
        return;
      }
      const {
        jobs
      } = await mlApi.getJobStats({
        jobId: jobIds.join(',')
      });
      const unassignedJobs = jobs.filter(isJobAwaitingNodeAssignment);
      setUnassignedJobCount(unassignedJobs.length);
    } catch (error) {
      setUnassignedJobCount(0);
      // eslint-disable-next-line no-console
      console.error('Could not determine ML node information', error);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobIds]);
  const checkCloudInfo = (0, _react.useCallback)(async () => {
    if (unassignedJobCount === 0) {
      return;
    }
    try {
      var _resp$cloudId, _resp$cloudUrl;
      const resp = await mlApi.mlInfo();
      const cloudId = (_resp$cloudId = resp.cloudId) !== null && _resp$cloudId !== void 0 ? _resp$cloudId : null;
      const isCloudTrial = resp.isCloudTrial === true;
      setShowNodeInfo(resp.showNodeInfo);
      setCloudInfo({
        isCloud: cloudId !== null,
        cloudId,
        isCloudTrial,
        deploymentId: cloudId === null ? null : (0, _ml_server_info.extractDeploymentId)(cloudId),
        isMlAutoscalingEnabled: resp.isMlAutoscalingEnabled,
        cloudUrl: (_resp$cloudUrl = resp.cloudUrl) !== null && _resp$cloudUrl !== void 0 ? _resp$cloudUrl : null
      });
    } catch (error) {
      setCloudInfo(null);
      // eslint-disable-next-line no-console
      console.error('Could not determine cloud information', error);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [unassignedJobCount]);
  (0, _react.useEffect)(() => {
    checkCloudInfo();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [unassignedJobCount]);
  (0, _react.useEffect)(() => {
    checkNodes();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobIds]);
  if (unassignedJobCount === 0) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobsAwaitingNodeWarningShared.title",
      defaultMessage: "Awaiting machine learning node",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 11
      }
    }),
    color: "primary",
    iconType: "info",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.jobsAwaitingNodeWarningShared.noMLNodesAvailableDescription",
    defaultMessage: "{jobCount, plural, one {# job} other {# jobs}} will start after autoscaling has increased ML capacity. This may take several minutes.",
    values: {
      jobCount: unassignedJobCount
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 11
    }
  }), cloudInfo && showNodeInfo && (cloudInfo.isCloud ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.jobsAwaitingNodeWarningShared.isCloud",
    defaultMessage: "Elastic Cloud deployments can autoscale to add more ML capacity. This may take 5-20 minutes. ",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 17
    }
  }), cloudInfo.deploymentId === null ? null : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.jobsAwaitingNodeWarningShared.isCloud.link",
    defaultMessage: "You can monitor progress in the {link}.",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: `https://cloud.elastic.co/deployments?q=${cloudInfo.deploymentId}`,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 136,
          columnNumber: 25
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.jobsAwaitingNodeWarningShared.linkToCloud.linkText",
        defaultMessage: "Elastic Cloud admin console",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 139,
          columnNumber: 27
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 19
    }
  })) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.jobsAwaitingNodeWarningShared.notCloud",
    defaultMessage: "Only Elastic Cloud deployments can autoscale; you must add machine learning nodes. {link}",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: 'https://www.elastic.co/guide/en/elasticsearch/reference/current/modules-node.html#ml-node',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 155,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.jobsAwaitingNodeWarningShared.linkToCloud.learnMore",
        defaultMessage: "Learn more.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 160,
          columnNumber: 23
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 7
    }
  }));
};

// eslint-disable-next-line import/no-default-export
var _default = exports.default = MLJobsAwaitingNodeWarning;
module.exports = exports.default;