"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ItemsGrid = ItemsGrid;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _items_grid_pagination = require("./items_grid_pagination");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/items_grid/items_grid.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
 * React component for a paged grid of items.
 */
function ItemsGrid({
  numberColumns,
  totalItemCount,
  items,
  selectedItems,
  itemsPerPage,
  itemsPerPageOptions,
  setItemsPerPage,
  setItemSelected,
  activePage,
  setActivePage
}) {
  if (items === undefined || items.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceAround",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 35,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 36,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("h4", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 13
      }
    }, totalItemCount === 0 ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.itemsGrid.noItemsAddedTitle",
      defaultMessage: "No items have been added",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 17
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.itemsGrid.noMatchingItemsTitle",
      defaultMessage: "No matching items",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 17
      }
    })))));
  }
  const startIndex = activePage * itemsPerPage;
  const pageItems = items.slice(startIndex, startIndex + itemsPerPage);
  const gridItems = pageItems.map((item, index) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: `ml_grid_item_${index}`,
      "data-test-subj": `mlGridItem ${item}`,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
      id: `ml_grid_item_${index}`,
      label: item,
      checked: selectedItems.indexOf(item) >= 0,
      onChange: e => {
        setItemSelected(item, e.target.checked);
      },
      "data-test-subj": `mlGridItemCheckbox`,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 9
      }
    }));
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: numberColumns,
    className: "eui-textBreakWord",
    gutterSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  }, gridItems), /*#__PURE__*/_react.default.createElement(_items_grid_pagination.ItemsGridPagination, {
    itemCount: items.length,
    itemsPerPage: itemsPerPage,
    itemsPerPageOptions: itemsPerPageOptions,
    setItemsPerPage: setItemsPerPage,
    activePage: activePage,
    setActivePage: setActivePage,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }));
}
ItemsGrid.propTypes = {
  numberColumns: _propTypes.default.oneOf([2, 3, 4]),
  // In line with EuiFlexGrid which supports 2, 3 or 4 columns.
  totalItemCount: _propTypes.default.number.isRequired,
  items: _propTypes.default.array,
  selectedItems: _propTypes.default.array,
  itemsPerPage: _propTypes.default.number,
  itemsPerPageOptions: _propTypes.default.arrayOf(_propTypes.default.number),
  setItemsPerPage: _propTypes.default.func.isRequired,
  setItemSelected: _propTypes.default.func.isRequired,
  activePage: _propTypes.default.number.isRequired,
  setActivePage: _propTypes.default.func.isRequired
};
ItemsGrid.defaultProps = {
  numberColumns: 4,
  itemsPerPage: 50,
  itemsPerPageOptions: [50, 100, 500, 1000]
};