"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useHelpPopoverStyles = void 0;
var _react = require("@emotion/react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useHelpPopoverStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return {
    helpPopoverPanel: (0, _react.css)({
      maxWidth: `${euiTheme.base * 30}px`
    }),
    helpPopoverContent: (0, _react.css)`
      ${(0, _eui.useEuiOverflowScroll)('y', true)};
      max-height: 40vh;
      padding: ${euiTheme.size.s};
    `
  };
};
exports.useHelpPopoverStyles = useHelpPopoverStyles;