"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultAnomaliesTableState = exports.AnomaliesTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _mlUrlState = require("@kbn/ml-url-state");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _useUpdateEffect = _interopRequireDefault(require("react-use/lib/useUpdateEffect"));
var _mlErrorUtils = require("@kbn/ml-error-utils");
var _kibana = require("../../contexts/kibana");
var _anomalies_table_constants = require("./anomalies_table_constants");
var _anomaly_details = require("./anomaly_details");
var _table_service = require("../../services/table_service");
var _anomalies_table_columns = require("./anomalies_table_columns");
var _rule_editor = require("../rule_editor");
var _ml_alerting_flyout = require("../../../alerting/ml_alerting_flyout");
var _build_alert_params_from_anomaly = require("./build_alert_params_from_anomaly");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/anomalies_table/anomalies_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getDefaultAnomaliesTableState = () => ({
  pageIndex: 0,
  pageSize: 25,
  sortField: 'severity',
  sortDirection: 'desc'
});
exports.getDefaultAnomaliesTableState = getDefaultAnomaliesTableState;
const AnomaliesTable = exports.AnomaliesTable = /*#__PURE__*/_react.default.memo(({
  bounds,
  tableData,
  filter,
  influencerFilter,
  sourceIndicesWithGeoFields,
  selectedJobs
}) => {
  const [tableState, updateTableState] = (0, _mlUrlState.usePageUrlState)('mlAnomaliesTable', getDefaultAnomaliesTableState());
  const [itemIdToExpandedRowMap, setItemIdToExpandedRowMap] = (0, _react.useState)({});

  // When the table data changes, reset the table page index to 0.
  (0, _useUpdateEffect.default)(() => {
    updateTableState({
      ...tableState,
      pageIndex: 0
    });
  }, [tableData]);
  const [showRuleEditorFlyout, setShowRuleEditorFlyout] = (0, _react.useState)(null);
  const [alertFlyoutVisible, setAlertFlyoutVisible] = (0, _react.useState)(false);
  const [alertFlyoutParams, setAlertFlyoutParams] = (0, _react.useState)();
  const {
    services: {
      mlServices
    }
  } = (0, _kibana.useMlKibana)();
  const mouseOverRecordRef = (0, _react.useRef)();
  const handleSetShowFunction = (0, _react.useCallback)(showFunction => {
    setShowRuleEditorFlyout(() => showFunction);
  }, []);
  const handleUnsetShowFunction = (0, _react.useCallback)(() => {
    setShowRuleEditorFlyout(null);
  }, []);
  const handleShowAnomalyAlertFlyout = (0, _react.useCallback)(anomaly => {
    const initialParams = (0, _build_alert_params_from_anomaly.buildAlertParamsFromAnomaly)(anomaly);
    setAlertFlyoutParams(initialParams);
    setAlertFlyoutVisible(true);
  }, []);
  (0, _react.useEffect)(function resetExpandedRowMap() {
    const expandedRowIds = Object.keys(itemIdToExpandedRowMap);
    const expandedNotInData = expandedRowIds.find(rowId => {
      return !tableData.anomalies.some(anomaly => anomaly.rowId === rowId);
    });
    if (expandedNotInData !== undefined) {
      setItemIdToExpandedRowMap({});
    }
  }, [itemIdToExpandedRowMap, tableData.anomalies]);
  const isShowingAggregatedData = (0, _react.useMemo)(() => {
    return tableData.interval !== 'second';
  }, [tableData.interval]);
  const toggleRow = (0, _react.useCallback)(async (item, tab = _anomalies_table_constants.ANOMALIES_TABLE_TABS.DETAILS) => {
    const newItemIdToExpandedRowMap = {
      ...itemIdToExpandedRowMap
    };
    if (newItemIdToExpandedRowMap[item.rowId]) {
      delete newItemIdToExpandedRowMap[item.rowId];
    } else {
      const examples = item.entityName === 'mlcategory' ? (0, _lodash.get)(tableData, ['examplesByJobId', item.jobId, item.entityValue]) : undefined;
      let definition;
      let categoryDefinitionError;
      if (examples !== undefined) {
        try {
          definition = await mlServices.mlApi.results.getCategoryDefinition(item.jobId, item.source.mlcategory[0]);
          if (definition.terms && definition.terms.length > _anomalies_table_constants.MAX_CHARS) {
            definition.terms = `${definition.terms.substring(0, _anomalies_table_constants.MAX_CHARS)}...`;
          }
          if (definition.regex && definition.regex.length > _anomalies_table_constants.MAX_CHARS) {
            definition.terms = `${definition.regex.substring(0, _anomalies_table_constants.MAX_CHARS)}...`;
          }
        } catch (error) {
          categoryDefinitionError = (0, _mlErrorUtils.extractErrorMessage)(error);
        }
      }
      const job = selectedJobs.find(({
        id
      }) => id === item.jobId);
      newItemIdToExpandedRowMap[item.rowId] = /*#__PURE__*/_react.default.createElement(_anomaly_details.AnomalyDetails, {
        tabIndex: tab,
        anomaly: item,
        examples: examples,
        definition: definition,
        categoryDefinitionError: categoryDefinitionError,
        isAggregatedData: isShowingAggregatedData,
        filter: filter,
        influencerFilter: influencerFilter,
        influencersLimit: _anomalies_table_constants.INFLUENCERS_LIMIT,
        job: job,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 168,
          columnNumber: 13
        }
      });
    }
    setItemIdToExpandedRowMap(newItemIdToExpandedRowMap);
  }, [filter, influencerFilter, isShowingAggregatedData, itemIdToExpandedRowMap, mlServices.mlApi.results, selectedJobs, tableData]);
  const onMouseOverRow = (0, _react.useCallback)(record => {
    if (mouseOverRecordRef.current !== undefined) {
      if (mouseOverRecordRef.current.rowId !== record.rowId) {
        // Mouse is over a different row, fire mouseleave on the previous record.
        _table_service.mlTableService.rowMouseleave$.next({
          record: mouseOverRecordRef.current
        });

        // fire mouseenter on the new record.
        _table_service.mlTableService.rowMouseenter$.next({
          record
        });
      }
    } else {
      // Mouse is now over a row, fire mouseenter on the record.
      _table_service.mlTableService.rowMouseenter$.next({
        record
      });
    }
    mouseOverRecordRef.current = record;
  }, []);
  const onMouseLeaveRow = (0, _react.useCallback)(() => {
    if (mouseOverRecordRef.current !== undefined) {
      _table_service.mlTableService.rowMouseleave$.next({
        record: mouseOverRecordRef.current
      });
      mouseOverRecordRef.current = undefined;
    }
  }, []);
  const onTableChange = (0, _react.useCallback)(criteria => {
    const {
      page,
      sort
    } = criteria;
    const result = {
      pageIndex: page && page.index !== undefined ? page.index : tableState.pageIndex,
      pageSize: page && page.size !== undefined ? page.size : tableState.pageSize,
      sortField: sort && sort.field !== undefined && typeof sort.field === 'string' ? sort.field : tableState.sortField,
      sortDirection: sort && sort.direction !== undefined ? sort.direction : tableState.sortDirection
    };
    updateTableState(result);
  }, [tableState, updateTableState]);
  const sorting = (0, _react.useMemo)(() => {
    return {
      sort: {
        field: tableState.sortField,
        direction: tableState.sortDirection
      }
    };
  }, [tableState.sortField, tableState.sortDirection]);
  const pagination = (0, _react.useMemo)(() => {
    return {
      pageIndex: tableState.pageIndex,
      pageSize: tableState.pageSize,
      totalItemCount: tableData.anomalies.length,
      pageSizeOptions: [10, 25, 100]
    };
  }, [tableState.pageIndex, tableState.pageSize, tableData.anomalies.length]);
  const columns = (0, _react.useMemo)(() => (0, _anomalies_table_columns.getColumns)(mlServices.mlFieldFormatService, tableData.anomalies, tableData.jobIds, tableData.examplesByJobId, isShowingAggregatedData, tableData.interval, bounds, tableData.showViewSeriesLink, showRuleEditorFlyout, itemIdToExpandedRowMap, toggleRow, filter, influencerFilter, sourceIndicesWithGeoFields, handleShowAnomalyAlertFlyout), [bounds, filter, influencerFilter, isShowingAggregatedData, itemIdToExpandedRowMap, mlServices.mlFieldFormatService, showRuleEditorFlyout, sourceIndicesWithGeoFields, tableData.anomalies, tableData.examplesByJobId, tableData.interval, tableData.jobIds, tableData.showViewSeriesLink, toggleRow, handleShowAnomalyAlertFlyout]);
  if (tableData === undefined || tableData.anomalies === undefined || tableData.anomalies.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceAround",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 300,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 301,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 302,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("h4", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 303,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.anomaliesTable.noMatchingAnomaliesFoundTitle",
      defaultMessage: "No matching anomalies found",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 304,
        columnNumber: 17
      }
    })))));
  }

  // Use auto table layout, unless any columns (categorization examples) have truncateText
  // set to true which only works with a fixed layout.
  const tableLayout = columns.some(column => 'truncateText' in column && column.truncateText === true) ? 'fixed' : 'auto';
  const getRowProps = item => {
    return {
      onMouseOver: () => onMouseOverRow(item),
      onMouseLeave: () => onMouseLeaveRow(),
      'data-test-subj': `mlAnomaliesListRow row-${item.rowId}`
    };
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_rule_editor.RuleEditorFlyout, {
    setShowFunction: handleSetShowFunction,
    unsetShowFunction: handleUnsetShowFunction,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 333,
      columnNumber: 9
    }
  }), alertFlyoutVisible && alertFlyoutParams && /*#__PURE__*/_react.default.createElement(_ml_alerting_flyout.MlAnomalyAlertFlyout, {
    onCloseFlyout: () => setAlertFlyoutVisible(false),
    initialParams: alertFlyoutParams,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 338,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    className: "eui-textBreakWord",
    items: tableData.anomalies
    // TODO - fix type
    ,
    columns: columns,
    tableLayout: tableLayout,
    pagination: pagination,
    sorting: sorting,
    itemId: "rowId",
    itemIdToExpandedRowMap: itemIdToExpandedRowMap,
    compressed: true,
    rowProps: getRowProps,
    "data-test-subj": "mlAnomaliesTable",
    onTableChange: onTableChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 343,
      columnNumber: 9
    }
  }));
}, (prevProps, nextProps) => {
  return (0, _lodash.isEqual)(prevProps, nextProps);
});