"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PLUGIN_ID = exports.PLUGIN_ICON_SOLUTION = exports.PLUGIN_ICON = exports.ML_MANAGEMENT_APP_ROUTE = exports.ML_INTERNAL_BASE_PATH = exports.ML_EXTERNAL_BASE_PATH = exports.ML_APP_ROUTE = exports.ML_APP_NAME = void 0;
exports.initEnabledFeatures = initEnabledFeatures;
exports.initExperimentalFeatures = initExperimentalFeatures;
exports.initModelDeploymentSettings = initModelDeploymentSettings;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PLUGIN_ID = exports.PLUGIN_ID = 'ml';
const PLUGIN_ICON = exports.PLUGIN_ICON = 'machineLearningApp';
const PLUGIN_ICON_SOLUTION = exports.PLUGIN_ICON_SOLUTION = 'logoKibana';
const ML_APP_NAME = exports.ML_APP_NAME = _i18n.i18n.translate('xpack.ml.navMenu.mlAppNameText', {
  defaultMessage: 'Machine Learning and Analytics'
});
const ML_APP_ROUTE = exports.ML_APP_ROUTE = '/app/ml';
const ML_MANAGEMENT_APP_ROUTE = exports.ML_MANAGEMENT_APP_ROUTE = '/app/management/ml';
const ML_INTERNAL_BASE_PATH = exports.ML_INTERNAL_BASE_PATH = '/internal/ml';
const ML_EXTERNAL_BASE_PATH = exports.ML_EXTERNAL_BASE_PATH = '/api/ml';
function initEnabledFeatures(enabledFeatures, config) {
  var _config$ad, _config$dfa, _config$nlp;
  if (((_config$ad = config.ad) === null || _config$ad === void 0 ? void 0 : _config$ad.enabled) !== undefined) {
    enabledFeatures.ad = config.ad.enabled;
  }
  if (((_config$dfa = config.dfa) === null || _config$dfa === void 0 ? void 0 : _config$dfa.enabled) !== undefined) {
    enabledFeatures.dfa = config.dfa.enabled;
  }
  if (((_config$nlp = config.nlp) === null || _config$nlp === void 0 ? void 0 : _config$nlp.enabled) !== undefined) {
    enabledFeatures.nlp = config.nlp.enabled;
  }
}
function initExperimentalFeatures(experimentalFeatures, config) {
  var _config$experimental, _config$experimental$;
  if (((_config$experimental = config.experimental) === null || _config$experimental === void 0 ? void 0 : (_config$experimental$ = _config$experimental.ruleFormV2) === null || _config$experimental$ === void 0 ? void 0 : _config$experimental$.enabled) !== undefined) {
    experimentalFeatures.ruleFormV2 = config.experimental.ruleFormV2.enabled;
  }
}
function initModelDeploymentSettings(nlpSettings, config) {
  var _config$nlp2;
  if (((_config$nlp2 = config.nlp) === null || _config$nlp2 === void 0 ? void 0 : _config$nlp2.modelDeployment) !== undefined) {
    nlpSettings.modelDeployment = config.nlp.modelDeployment;
  }
}