"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNumTopFeatureImportanceValues = void 0;
var _analytics_utils = require("./analytics_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Get the `num_top_feature_importance_values` attribute of DFA regression and classification configurations
 *
 * @param {AnalysisConfig} analysis The analysis configuration
 * @returns {(| RegressionAnalysis['regression']['num_top_feature_importance_values']
  | ClassificationAnalysis['classification']['num_top_feature_importance_values'])}
 */
const getNumTopFeatureImportanceValues = analysis => {
  let numTopFeatureImportanceValues;
  if ((0, _analytics_utils.isRegressionAnalysis)(analysis) && analysis.regression.num_top_feature_importance_values !== undefined) {
    numTopFeatureImportanceValues = analysis.regression.num_top_feature_importance_values;
  } else if ((0, _analytics_utils.isClassificationAnalysis)(analysis) && analysis.classification.num_top_feature_importance_values !== undefined) {
    numTopFeatureImportanceValues = analysis.classification.num_top_feature_importance_values;
  }
  return numTopFeatureImportanceValues;
};
exports.getNumTopFeatureImportanceValues = getNumTopFeatureImportanceValues;