"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sortExplorationResultsFields = exports.ML__INCREMENTAL_ID = exports.ML__ID_COPY = exports.MAX_COLUMNS = exports.EXTENDED_NUMERICAL_TYPES = exports.DEFAULT_REGRESSION_COLUMNS = exports.BASIC_NUMERICAL_TYPES = void 0;
var _fieldTypes = require("@kbn/field-types");
var _analytics_utils = require("./analytics_utils");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * ES id _id
 */

/**
 * ES source _source
 */

/**
 * ES field name
 */

/**
 * ES doc
 */

/**
 * Max columns
 */
const MAX_COLUMNS = exports.MAX_COLUMNS = 10;

/**
 * Default regression columns
 */
const DEFAULT_REGRESSION_COLUMNS = exports.DEFAULT_REGRESSION_COLUMNS = 8;

/**
 * Set of basic numerical types
 */
const BASIC_NUMERICAL_TYPES = exports.BASIC_NUMERICAL_TYPES = new Set([_fieldTypes.ES_FIELD_TYPES.UNSIGNED_LONG, _fieldTypes.ES_FIELD_TYPES.LONG, _fieldTypes.ES_FIELD_TYPES.INTEGER, _fieldTypes.ES_FIELD_TYPES.SHORT, _fieldTypes.ES_FIELD_TYPES.BYTE]);

/**
 * Set of extended numerical types
 */
const EXTENDED_NUMERICAL_TYPES = exports.EXTENDED_NUMERICAL_TYPES = new Set([_fieldTypes.ES_FIELD_TYPES.DOUBLE, _fieldTypes.ES_FIELD_TYPES.FLOAT, _fieldTypes.ES_FIELD_TYPES.HALF_FLOAT, _fieldTypes.ES_FIELD_TYPES.SCALED_FLOAT]);

/**
 * ES field name for copy of the doc _id
 */
// eslint-disable-next-line @typescript-eslint/naming-convention
const ML__ID_COPY = exports.ML__ID_COPY = 'ml__id_copy';

/**
 * ES field name for ML's incremental id
 */
// eslint-disable-next-line @typescript-eslint/naming-convention
const ML__INCREMENTAL_ID = exports.ML__INCREMENTAL_ID = 'ml__incremental_id';

/**
 * Used to sort columns:
 * - Anchor on the left ml.outlier_score, ml.is_training, <predictedField>, <actual>
 * - string based columns are moved to the left
 * - feature_influence/feature_importance fields get moved next to the corresponding field column
 * - overall fields get sorted alphabetically
 *
 * @param {string} a First field name to compare for sorting
 * @param {string} b Second field name to compare for sorting
 * @param {DataFrameAnalyticsConfig} jobConfig The DFA analysis config
 * @returns {*}
 */
const sortExplorationResultsFields = (a, b, jobConfig) => {
  const resultsField = jobConfig.dest.results_field;
  if ((0, _analytics_utils.isOutlierAnalysis)(jobConfig.analysis)) {
    if (a === `${resultsField}.${_constants.OUTLIER_SCORE}`) {
      return -1;
    }
    if (b === `${resultsField}.${_constants.OUTLIER_SCORE}`) {
      return 1;
    }
  }
  if ((0, _analytics_utils.isClassificationAnalysis)(jobConfig.analysis) || (0, _analytics_utils.isRegressionAnalysis)(jobConfig.analysis)) {
    const dependentVariable = (0, _analytics_utils.getDependentVar)(jobConfig.analysis);
    const predictedField = (0, _analytics_utils.getPredictedFieldName)(resultsField, jobConfig.analysis, true);
    if (a === `${resultsField}.is_training`) {
      return -1;
    }
    if (b === `${resultsField}.is_training`) {
      return 1;
    }
    if (a === predictedField) {
      return -1;
    }
    if (b === predictedField) {
      return 1;
    }
    if (a === dependentVariable || a === dependentVariable.replace(/\.keyword$/, '')) {
      return -1;
    }
    if (b === dependentVariable || b === dependentVariable.replace(/\.keyword$/, '')) {
      return 1;
    }
    if (a === `${resultsField}.prediction_probability`) {
      return -1;
    }
    if (b === `${resultsField}.prediction_probability`) {
      return 1;
    }
  }
  const typeofA = typeof a;
  const typeofB = typeof b;
  const tokensA = a.split('.');
  const prefixA = tokensA[0];
  const tokensB = b.split('.');
  const prefixB = tokensB[0];
  if (prefixA === resultsField && tokensA.length > 1 && prefixB !== resultsField) {
    tokensA.shift();
    tokensA.shift();
    if (tokensA.join('.') === b) return 1;
    return tokensA.join('.').localeCompare(b);
  }
  if (prefixB === resultsField && tokensB.length > 1 && prefixA !== resultsField) {
    tokensB.shift();
    tokensB.shift();
    if (tokensB.join('.') === a) return -1;
    return a.localeCompare(tokensB.join('.'));
  }
  if (typeofA !== 'string' && typeofB === 'string') {
    return 1;
  }
  if (typeofA === 'string' && typeofB !== 'string') {
    return -1;
  }
  if (typeofA === 'string' && typeofB === 'string') {
    return a.localeCompare(b);
  }
  return a.localeCompare(b);
};
exports.sortExplorationResultsFields = sortExplorationResultsFields;