"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setEsqlRecommendedQueries = setEsqlRecommendedQueries;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// Define ES|QL plugin interface locally to match the plugin implementation

const METRICS_INDEX_PATTERN = 'metrics-*';
const solutions = ['security', 'oblt', 'es'];
const METRICS_EXPERIENCE_ESQL_RECOMMENDED_QUERIES = [{
  name: _i18n.i18n.translate('xpack.metricsExperience.esqlQueries.allMetrics.name', {
    defaultMessage: 'All metrics'
  }),
  query: `TS ${METRICS_INDEX_PATTERN}`,
  description: _i18n.i18n.translate('xpack.metricsExperience.esqlQueries.allMetrics.description', {
    defaultMessage: 'Loads all available metrics'
  })
}];
function setEsqlRecommendedQueries(esqlPlugin) {
  const esqlExtensionsRegistry = esqlPlugin.getExtensionsRegistry();
  solutions.forEach(solutionId => {
    esqlExtensionsRegistry.setRecommendedQueries([...METRICS_EXPERIENCE_ESQL_RECOMMENDED_QUERIES], solutionId);
  });
}