"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.metrics = void 0;
var _aws_s3_bucket_size = require("./tsvb/aws_s3_bucket_size");
var _aws_s3_total_requests = require("./tsvb/aws_s3_total_requests");
var _aws_s3_number_of_objects = require("./tsvb/aws_s3_number_of_objects");
var _aws_s3_download_bytes = require("./tsvb/aws_s3_download_bytes");
var _aws_s3_upload_bytes = require("./tsvb/aws_s3_upload_bytes");
var _metrics_catalog = require("../../shared/metrics/metrics_catalog");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const metrics = exports.metrics = {
  tsvb: {
    awsS3BucketSize: _aws_s3_bucket_size.awsS3BucketSize,
    awsS3TotalRequests: _aws_s3_total_requests.awsS3TotalRequests,
    awsS3NumberOfObjects: _aws_s3_number_of_objects.awsS3NumberOfObjects,
    awsS3DownloadBytes: _aws_s3_download_bytes.awsS3DownloadBytes,
    awsS3UploadBytes: _aws_s3_upload_bytes.awsS3UploadBytes
  },
  requiredTsvb: ['awsS3BucketSize', 'awsS3NumberOfObjects', 'awsS3TotalRequests', 'awsS3DownloadBytes', 'awsS3UploadBytes'],
  getAggregations: async args => {
    const {
      snapshot
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./snapshot')));
    const catalog = new _metrics_catalog.MetricsCatalog(snapshot, args === null || args === void 0 ? void 0 : args.schema);
    return catalog;
  },
  getWaffleMapTooltipMetrics: () => ['s3BucketSize', 's3NumberOfObjects', 's3TotalRequests', 's3UploadBytes', 's3DownloadBytes'],
  defaultSnapshot: 's3BucketSize',
  defaultTimeRangeInSeconds: 86400 * 7 // 7 days
};