"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MapsPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _server = require("@kbn/core/server");
var _common = require("@kbn/data-views-plugin/common");
var _content_management = require("../common/content_management");
var _ecommerce_saved_objects = require("./sample_data/ecommerce_saved_objects");
var _flights_saved_objects = require("./sample_data/flights_saved_objects");
var _web_logs_saved_objects = require("./sample_data/web_logs_saved_objects");
var _register = require("./maps_telemetry/collectors/register");
var _constants = require("../common/constants");
var _kibana_server_services = require("./kibana_server_services");
var _ems = require("./tutorials/ems");
var _routes = require("./routes");
var _embeddable = require("./embeddable");
var _saved_objects = require("./saved_objects");
var _register_integrations = require("./register_integrations");
var _content_management2 = require("./content_management");
var _get_transforms = require("../common/embeddable/transforms/get_transforms");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class MapsPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "_initializerContext", void 0);
    (0, _defineProperty2.default)(this, "_logger", void 0);
    this._logger = initializerContext.logger.get();
    this._initializerContext = initializerContext;
  }
  _initHomeData(home, prependBasePath, emsSettings) {
    const sampleDataLinkLabel = _i18n.i18n.translate('xpack.maps.sampleDataLinkLabel', {
      defaultMessage: 'Map'
    });
    home.sampleData.addSavedObjectsToSampleDataset('ecommerce', (0, _ecommerce_saved_objects.getEcommerceSavedObjects)());
    home.sampleData.addAppLinksToSampleDataset('ecommerce', [{
      sampleObject: {
        type: _constants.MAP_SAVED_OBJECT_TYPE,
        id: '2c9c1f60-1909-11e9-919b-ffe5949a18d2'
      },
      getPath: _constants.getFullPath,
      label: sampleDataLinkLabel,
      icon: _constants.APP_ICON
    }]);
    home.sampleData.replacePanelInSampleDatasetDashboard({
      sampleDataId: 'ecommerce',
      dashboardId: '722b74f0-b882-11e8-a6d9-e546fe2bba5f',
      oldEmbeddableId: '9c6f83f0-bb4d-11e8-9c84-77068524bcab',
      embeddableId: '2c9c1f60-1909-11e9-919b-ffe5949a18d2',
      // @ts-expect-error
      embeddableType: _constants.MAP_SAVED_OBJECT_TYPE,
      embeddableConfig: {
        isLayerTOCOpen: false,
        hiddenLayers: [],
        mapCenter: {
          lat: 45.88578,
          lon: -15.07605,
          zoom: 2.11
        },
        openTOCDetails: []
      }
    });
    home.sampleData.addSavedObjectsToSampleDataset('flights', (0, _flights_saved_objects.getFlightsSavedObjects)());
    home.sampleData.addAppLinksToSampleDataset('flights', [{
      sampleObject: {
        type: _constants.MAP_SAVED_OBJECT_TYPE,
        id: '5dd88580-1906-11e9-919b-ffe5949a18d2'
      },
      getPath: _constants.getFullPath,
      label: sampleDataLinkLabel,
      icon: _constants.APP_ICON
    }]);
    home.sampleData.replacePanelInSampleDatasetDashboard({
      sampleDataId: 'flights',
      dashboardId: '7adfa750-4c81-11e8-b3d7-01146121b73d',
      oldEmbeddableId: '334084f0-52fd-11e8-a160-89cc2ad9e8e2',
      embeddableId: '5dd88580-1906-11e9-919b-ffe5949a18d2',
      // @ts-expect-error
      embeddableType: _constants.MAP_SAVED_OBJECT_TYPE,
      embeddableConfig: {
        isLayerTOCOpen: true,
        hiddenLayers: [],
        mapCenter: {
          lat: 48.72307,
          lon: -115.18171,
          zoom: 4.28
        },
        openTOCDetails: []
      }
    });
    home.sampleData.addSavedObjectsToSampleDataset('logs', (0, _web_logs_saved_objects.getWebLogsSavedObjects)());
    home.sampleData.addAppLinksToSampleDataset('logs', [{
      sampleObject: {
        type: _constants.MAP_SAVED_OBJECT_TYPE,
        id: 'de71f4f0-1902-11e9-919b-ffe5949a18d2'
      },
      getPath: _constants.getFullPath,
      label: sampleDataLinkLabel,
      icon: _constants.APP_ICON
    }]);
    home.sampleData.replacePanelInSampleDatasetDashboard({
      sampleDataId: 'logs',
      dashboardId: 'edf84fe0-e1a0-11e7-b6d5-4dc382ef7f5b',
      oldEmbeddableId: '06cf9c40-9ee8-11e7-8711-e7a007dcef99',
      embeddableId: 'de71f4f0-1902-11e9-919b-ffe5949a18d2',
      // @ts-expect-error
      embeddableType: _constants.MAP_SAVED_OBJECT_TYPE,
      embeddableConfig: {
        isLayerTOCOpen: false,
        hiddenLayers: [],
        mapCenter: {
          lat: 42.16337,
          lon: -88.92107,
          zoom: 3.64
        },
        openTOCDetails: []
      }
    });
    home.tutorials.registerTutorial((0, _ems.emsBoundariesSpecProvider)({
      prependBasePath,
      emsLandingPageUrl: emsSettings.getEMSLandingPageUrl()
    }));
  }
  setup(core, plugins) {
    const getFilterMigrations = plugins.data.query.filterManager.getAllMigrations.bind(plugins.data.query.filterManager);
    const getDataViewMigrations = _common.DataViewPersistableStateService.getAllMigrations.bind(_common.DataViewPersistableStateService);
    const {
      usageCollection,
      home,
      features,
      customIntegrations,
      contentManagement
    } = plugins;
    const config$ = this._initializerContext.config.create();
    const emsSettings = plugins.mapsEms.createEMSSettings();
    (0, _routes.initRoutes)(core, this._logger);
    if (home) {
      this._initHomeData(home, core.http.basePath.prepend, emsSettings);
    }
    if (customIntegrations) {
      (0, _register_integrations.registerIntegrations)(core, customIntegrations);
    }
    const getBaseMapsFeature = version => {
      const apiAllPrivileges = [];
      const savedObjectAllPrivileges = [_constants.MAP_SAVED_OBJECT_TYPE];
      const uiAllPrivileges = ['save', 'show'];
      const apiReadPrivileges = [];
      const savedObjectReadPrivileges = [_constants.MAP_SAVED_OBJECT_TYPE, 'index-pattern', 'tag'];
      if (version === 'v1') {
        apiAllPrivileges.push('savedQuery:manage', 'savedQuery:read');
        savedObjectAllPrivileges.push('query');
        uiAllPrivileges.push('saveQuery');
        apiReadPrivileges.push('savedQuery:read');
        savedObjectReadPrivileges.push('query');
      }
      return {
        name: _i18n.i18n.translate('xpack.maps.featureRegistry.mapsFeatureName', {
          defaultMessage: 'Maps'
        }),
        category: _server.DEFAULT_APP_CATEGORIES.kibana,
        app: [_constants.APP_ID, 'kibana'],
        catalogue: [_constants.APP_ID],
        privileges: {
          all: {
            app: [_constants.APP_ID, 'kibana'],
            api: apiAllPrivileges,
            catalogue: [_constants.APP_ID],
            savedObject: {
              all: savedObjectAllPrivileges,
              read: ['index-pattern', 'tag']
            },
            ui: uiAllPrivileges,
            ...(version === 'v1' && {
              replacedBy: [{
                feature: 'maps_v2',
                privileges: ['all']
              }, {
                feature: 'savedQueryManagement',
                privileges: ['all']
              }]
            })
          },
          read: {
            app: [_constants.APP_ID, 'kibana'],
            api: apiReadPrivileges,
            catalogue: [_constants.APP_ID],
            savedObject: {
              all: [],
              read: savedObjectReadPrivileges
            },
            ui: ['show'],
            ...(version === 'v1' && {
              replacedBy: {
                default: [{
                  feature: 'maps_v2',
                  privileges: ['read']
                }, {
                  feature: 'savedQueryManagement',
                  privileges: ['read']
                }],
                minimal: [{
                  feature: 'maps_v2',
                  privileges: ['minimal_read']
                }, {
                  feature: 'savedQueryManagement',
                  privileges: ['minimal_read']
                }]
              }
            })
          }
        }
      };
    };
    features.registerKibanaFeature({
      deprecated: {
        notice: _i18n.i18n.translate('xpack.maps.featureRegistry.mapsFeatureDeprecationNotice', {
          defaultMessage: 'The Maps V1 privilege has been deprecated and replaced with a Maps V2 privilege in order to improve saved query management. See {link} for more details.',
          values: {
            link: 'https://github.com/elastic/kibana/pull/202863'
          }
        }),
        replacedBy: ['maps_v2']
      },
      id: _constants.APP_ID,
      order: 400,
      ...getBaseMapsFeature('v1')
    });
    features.registerKibanaFeature({
      id: 'maps_v2',
      order: 401,
      ...getBaseMapsFeature('v2')
    });
    (0, _saved_objects.setupSavedObjects)(core, getFilterMigrations, getDataViewMigrations);
    (0, _register.registerMapsUsageCollector)(usageCollection);
    contentManagement.register({
      id: _content_management.CONTENT_ID,
      storage: new _content_management2.MapsStorage({
        throwOnResultValidationError: this._initializerContext.env.mode.dev,
        logger: this._logger.get('storage')
      }),
      version: {
        latest: _content_management.LATEST_VERSION
      }
    });
    (0, _embeddable.setupEmbeddable)(plugins.embeddable, getFilterMigrations, getDataViewMigrations);
    plugins.embeddable.registerTransforms(_constants.MAP_SAVED_OBJECT_TYPE, (0, _get_transforms.getTransforms)(plugins.embeddable.transformEnhancementsIn, plugins.embeddable.transformEnhancementsOut));
    return {
      config: config$
    };
  }
  start(core, plugins) {
    (0, _kibana_server_services.setStartServices)(core);
  }
}
exports.MapsPlugin = MapsPlugin;