"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ESSearchSourceSchema = exports.ESQLSourceSchema = exports.BaseESSourceSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _search = require("@kbn/data-plugin/common/search");
var _common = require("../../../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const applyForceRefreshSchema = _configSchema.schema.maybe(_configSchema.schema.boolean({
  defaultValue: true,
  meta: {
    description: `When true, results are re-fetched when page's automatic refresh fires or user clicks 'Refresh'.`
  }
}));
const narrowByGlobalSearch = _configSchema.schema.maybe(_configSchema.schema.boolean({
  defaultValue: true,
  meta: {
    description: `When true, results narrowed by page's search bar.`
  }
}));
const narrowByGlobalTime = _configSchema.schema.maybe(_configSchema.schema.boolean({
  defaultValue: true,
  meta: {
    description: `When true, results narrowed by page's time range.`
  }
}));

// base schema for Elasticsearch DSL sources
const BaseESSourceSchema = exports.BaseESSourceSchema = _configSchema.schema.object({
  applyForceRefresh: applyForceRefreshSchema,
  applyGlobalQuery: narrowByGlobalSearch,
  applyGlobalTime: narrowByGlobalTime,
  id: _configSchema.schema.string({
    meta: {
      description: 'uuid.'
    }
  }),
  indexPatternId: _configSchema.schema.string({
    meta: {
      description: 'Data view id from which results are pulled.'
    }
  })
}, {
  meta: {
    description: 'Elasticsearch JSON-based query language state'
  },
  unknowns: 'forbid'
});
const ESSearchSourceSchema = exports.ESSearchSourceSchema = BaseESSourceSchema.extends({
  filterByMapBounds: _configSchema.schema.maybe(_configSchema.schema.boolean({
    defaultValue: true
  })),
  geoField: _configSchema.schema.string({
    meta: {
      description: 'Field containing indexed geo-point or geo-shape values.'
    }
  }),
  scalingType: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(_common.SCALING_TYPES.LIMIT), _configSchema.schema.literal(_common.SCALING_TYPES.CLUSTERS), _configSchema.schema.literal(_common.SCALING_TYPES.MVT), _configSchema.schema.literal(_common.SCALING_TYPES.TOP_HITS)], {
    defaultValue: _common.SCALING_TYPES.MVT,
    meta: {
      description: `Elastic limits results to the index.max_result_window index setting, which defaults to 10000. Use scalingType to adjust limit behavior. With ${_common.SCALING_TYPES.LIMIT}, results limited to 10,000. With ${_common.SCALING_TYPES.CLUSTERS}, clusters are returned when results exceed 10,000. With ${_common.SCALING_TYPES.MVT}, results are returned as vector tiles. Each tile request is limited to the index.max_result_window index setting. With ${_common.SCALING_TYPES.TOP_HITS}, the most recent documents per entity are returned.`
    }
  })),
  sortField: _configSchema.schema.maybe(_configSchema.schema.string()),
  sortOrder: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(_search.SortDirection.asc), _configSchema.schema.literal(_search.SortDirection.desc)], {
    defaultValue: _search.SortDirection.desc
  })),
  topHitsGroupByTimeseries: _configSchema.schema.maybe(_configSchema.schema.boolean({
    defaultValue: false,
    meta: {
      description: `When true, top hits is grouped by time_series aggregation. Ignored when scalingType is not ${_common.SCALING_TYPES.TOP_HITS}.`
    }
  })),
  topHitsSplitField: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: `Field used to group top hits by term aggregation. Required when scalingType is ${_common.SCALING_TYPES.TOP_HITS} and topHitsGroupByTimeseries is false. Ignored when scalingType is not ${_common.SCALING_TYPES.TOP_HITS} or topHitsGroupByTimeseries is true.`
    }
  })),
  topHitsSize: _configSchema.schema.maybe(_configSchema.schema.number({
    meta: {
      description: `Number of hits to gather per entity. Ignored when scalingType is not ${_common.SCALING_TYPES.TOP_HITS}.`
    }
  })),
  tooltipProperties: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string(), {
    meta: {
      description: 'Document properties displayed in tooltip.'
    }
  })),
  type: _configSchema.schema.literal(_common.SOURCE_TYPES.ES_SEARCH)
}, {
  meta: {
    description: 'Vector tile or vector feature source returning points, lines, and polygons from Elasticsearch documents.'
  },
  unknowns: 'forbid'
});
const ESQLSourceSchema = exports.ESQLSourceSchema = _configSchema.schema.object({
  applyForceRefresh: applyForceRefreshSchema,
  dateField: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: `Date field used to narrow ES|QL requests by global time range. Required when 'narrowByGlobalTime' is true.`
    }
  })),
  esql: _configSchema.schema.string({
    meta: {
      description: 'ES|QL statement returning at least one geo_point or geo_shape column.'
    }
  }),
  geoField: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: `Geo field used to narrow ES|QL requests by visible map area and spatial filters drawn on map. Required when 'narrowByMapBounds' is true.`
    }
  })),
  id: _configSchema.schema.string({
    meta: {
      description: 'uuid.'
    }
  }),
  narrowByMapBounds: _configSchema.schema.maybe(_configSchema.schema.boolean({
    meta: {
      description: `When true, results narrowed by visible map area.`
    }
  })),
  narrowByGlobalSearch,
  narrowByGlobalTime,
  type: _configSchema.schema.literal(_common.SOURCE_TYPES.ESQL)
}, {
  meta: {
    description: 'Vector feature source returning points, lines, and polygons from Elasticsearch ES|QL request. One feature is returned per response row. Feature geometry is provided from first geo_point or geo_shape column.'
  },
  unknowns: 'forbid'
});