"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeProjectRoutingManager = initializeProjectRoutingManager;
var _std = require("@kbn/std");
var _rxjs = require("rxjs");
var _map_selectors = require("../selectors/map_selectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getProjectRoutingOverrides(layers) {
  const overrides = [];
  await (0, _std.asyncForEach)(layers, async layer => {
    var _layer$getProjectRout;
    const layerOverrides = await ((_layer$getProjectRout = layer.getProjectRoutingOverrides) === null || _layer$getProjectRout === void 0 ? void 0 : _layer$getProjectRout.call(layer));
    if (layerOverrides) {
      overrides.push(...layerOverrides);
    }
  });
  return overrides.length > 0 ? overrides : undefined;
}
async function initializeProjectRoutingManager(savedMap) {
  const store = savedMap.getStore();

  // TODO update projectRoutingOverrides$ on layer changes when inline editing is implemented
  const projectRoutingOverrides$ = new _rxjs.BehaviorSubject(await getProjectRoutingOverrides((0, _map_selectors.getLayerList)(store.getState())));
  return {
    api: {
      projectRoutingOverrides$
    }
  };
}