"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeFetch = initializeFetch;
var _rxjs = require("rxjs");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _kibana_services = require("../kibana_services");
var _actions = require("../actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getIsRestore(searchSessionId) {
  if (!searchSessionId) {
    return false;
  }
  const searchSessionOptions = (0, _kibana_services.getSearchService)().session.getSearchOptions(searchSessionId);
  return searchSessionOptions ? searchSessionOptions.isRestore : false;
}
function initializeFetch({
  api,
  controlledBy,
  getIsFilterByMapExtent,
  searchSessionMapBuffer,
  store
}) {
  let prevIsRestore;
  const fetchSubscription = (0, _presentationPublishing.fetch$)(api).subscribe(fetchContext => {
    // New search session id causes all layers from elasticsearch to refetch data.
    // Dashboard provides a new search session id anytime filters change.
    // Thus, filtering embeddable container by map extent causes a new search session id any time the map is moved.
    // Disabling search session when filtering embeddable container by map extent.
    // The use case for search sessions (restoring results because of slow responses) does not match the use case of
    // filtering by map extent (rapid responses as users explore their map).
    const searchSessionId = getIsFilterByMapExtent() ? undefined : fetchContext.searchSessionId;
    const isRestore = getIsRestore(searchSessionId);

    // Map can not be interacted with when viewing session restore.
    // Session restore only show data for cached extent and new data can not be fetch
    if (isRestore !== prevIsRestore) {
      prevIsRestore = isRestore;
      store.dispatch((0, _actions.setMapSettings)({
        disableInteractive: isRestore,
        hideToolbarOverlay: isRestore
      }));
    }
    store.dispatch((0, _actions.setQuery)({
      filters: fetchContext.filters ? fetchContext.filters.filter(filter => !filter.meta.disabled && filter.meta.controlledBy !== controlledBy) : [],
      query: fetchContext.query,
      timeFilters: fetchContext.timeRange,
      timeslice: fetchContext.timeslice ? {
        from: fetchContext.timeslice[0],
        to: fetchContext.timeslice[1]
      } : undefined,
      clearTimeslice: fetchContext.timeslice === undefined,
      forceRefresh: fetchContext.isReload,
      searchSessionId,
      searchSessionMapBuffer: isRestore ? searchSessionMapBuffer : undefined,
      projectRouting: fetchContext.projectRouting
    }));
  });
  const parentPauseFetch = (0, _presentationPublishing.apiHasParentApi)(api) && (0, _presentationPublishing.apiPublishesPauseFetch)(api.parentApi) ? api.parentApi.isFetchPaused$ : (0, _rxjs.of)(false);
  const apiPauseFetch = (0, _presentationPublishing.apiPublishesPauseFetch)(api) ? api.isFetchPaused$ : (0, _rxjs.of)(false);
  const isPausedSubscription = (0, _rxjs.combineLatest)([parentPauseFetch, apiPauseFetch]).pipe((0, _rxjs.map)(([parentPause, apiPause]) => {
    return parentPause || apiPause;
  })).subscribe(isFetchPaused => {
    store.dispatch((0, _actions.setPauseSyncData)(isFetchPaused));
  });
  return () => {
    fetchSubscription.unsubscribe();
    isPausedSubscription === null || isPausedSubscription === void 0 ? void 0 : isPausedSubscription.unsubscribe();
  };
}