"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEmsSuggestion = getEmsSuggestion;
var _ems_autosuggest = require("../../ems_autosuggest");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getEmsSuggestion(emsFileLayers, table, regionAccessor) {
  const keys = [];
  table.rows.forEach(row => {
    const key = row[regionAccessor];
    if (key && key !== '__other__' && !keys.includes(key)) {
      keys.push(key);
    }
  });
  return (0, _ems_autosuggest.emsAutoSuggest)({
    sampleValues: keys
  }, emsFileLayers);
}