"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TOCEntry = void 0;
var _reactRedux = require("react-redux");
var _toc_entry = require("./toc_entry");
var _ui = require("../../../../../reducers/ui");
var _map_selectors = require("../../../../../selectors/map_selectors");
var _ui_selectors = require("../../../../../selectors/ui_selectors");
var _non_serializable_instances = require("../../../../../reducers/non_serializable_instances");
var _actions = require("../../../../../actions");
var _constants = require("../../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function mapStateToProps(state, ownProps) {
  var _getEditState;
  const flyoutDisplay = (0, _ui_selectors.getFlyoutDisplay)(state);
  return {
    inspectorAdapters: (0, _non_serializable_instances.getInspectorAdapters)(state),
    isReadOnly: (0, _ui_selectors.getIsReadOnly)(state),
    zoom: (0, _map_selectors.getMapZoom)(state),
    selectedLayer: (0, _map_selectors.getSelectedLayer)(state),
    hasDirtyStateSelector: (0, _map_selectors.hasDirtyState)(state),
    isLegendDetailsOpen: (0, _ui_selectors.getOpenTOCDetails)(state).includes(ownProps.layer.getId()),
    isEditButtonDisabled: flyoutDisplay !== _ui.FLYOUT_STATE.NONE && flyoutDisplay !== _ui.FLYOUT_STATE.LAYER_PANEL,
    isFeatureEditorOpenForLayer: ((_getEditState = (0, _map_selectors.getEditState)(state)) === null || _getEditState === void 0 ? void 0 : _getEditState.layerId) === ownProps.layer.getId()
  };
}
function mapDispatchToProps(dispatch) {
  return {
    fitToBounds: layerId => {
      dispatch((0, _actions.fitToLayerExtent)(layerId));
    },
    openLayerPanel: async layerId => {
      await dispatch((0, _actions.setSelectedLayer)(layerId));
      dispatch((0, _actions.updateFlyout)(_ui.FLYOUT_STATE.LAYER_PANEL));
    },
    hideTOCDetails: layerId => {
      dispatch((0, _actions.hideTOCDetails)(layerId));
    },
    showTOCDetails: layerId => {
      dispatch((0, _actions.showTOCDetails)(layerId));
    },
    toggleVisible: layerId => {
      dispatch((0, _actions.toggleLayerVisible)(layerId));
    },
    cancelEditing: () => {
      dispatch((0, _actions.updateDrawState)(null));
      dispatch((0, _actions.setDrawMode)(_constants.DRAW_MODE.NONE));
    }
  };
}
const connected = exports.TOCEntry = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(_toc_entry.TOCEntry);