"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.esqlLayerWizardConfig = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _create_source_editor = require("./create_source_editor");
var _esql_source = require("./esql_source");
var _constants = require("../../../../common/constants");
var _vector_layer = require("../../layers/vector_layer");
var _documents_layer_icon = require("../../layers/wizards/icons/documents_layer_icon");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/sources/esql_source/esql_layer_wizard.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const esqlLayerWizardConfig = exports.esqlLayerWizardConfig = {
  id: _constants.WIZARD_ID.ESQL,
  order: 10,
  categories: [_constants.LAYER_WIZARD_CATEGORY.ELASTICSEARCH],
  description: _i18n.i18n.translate('xpack.maps.source.esqlDescription', {
    defaultMessage: 'Create a layer using the Elasticsearch Query Language'
  }),
  icon: _documents_layer_icon.DocumentsLayerIcon,
  isBeta: true,
  renderWizard: ({
    previewLayers,
    mapColors,
    mostCommonDataViewId
  }) => {
    const onSourceConfigChange = sourceConfig => {
      if (!sourceConfig) {
        previewLayers([]);
        return;
      }
      const sourceDescriptor = _esql_source.ESQLSource.createDescriptor(sourceConfig);
      const layerDescriptor = _vector_layer.GeoJsonVectorLayer.createDescriptor({
        sourceDescriptor
      }, mapColors);
      previewLayers([layerDescriptor]);
    };
    return /*#__PURE__*/_react.default.createElement(_create_source_editor.CreateSourceEditor, {
      mostCommonDataViewId: mostCommonDataViewId,
      onSourceConfigChange: onSourceConfigChange,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 7
      }
    });
  },
  title: _esql_source.sourceTitle
};