"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLayerWizards = getLayerWizards;
exports.getWizardById = getWizardById;
exports.registerLayerWizardExternal = registerLayerWizardExternal;
exports.registerLayerWizardInternal = registerLayerWizardInternal;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable @typescript-eslint/consistent-type-definitions */

const registry = [];
function registerLayerWizardInternal(layerWizard) {
  registry.push({
    checkVisibility: async () => {
      return true;
    },
    getIsDisabled: async () => {
      return false;
    },
    isBeta: false,
    ...layerWizard
  });
}
function registerLayerWizardExternal(layerWizard) {
  if (layerWizard.order < 100) {
    throw new Error(`layerWizard.order should be greater than or equal to '100'`);
  }
  registerLayerWizardInternal(layerWizard);
}
async function getLayerWizards() {
  const promises = registry.map(async layerWizard => {
    return {
      ...layerWizard,
      isVisible: await layerWizard.checkVisibility(),
      isDisabled: await layerWizard.getIsDisabled()
    };
  });
  return (await Promise.all(promises)).filter(({
    isVisible
  }) => {
    return isVisible;
  }).sort((wizard1, wizard2) => {
    return wizard1.order - wizard2.order;
  });
}
function getWizardById(wizardId) {
  return registry.find(wizard => wizard.id === wizardId);
}