"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CountAggField = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _constants = require("../../../../common/constants");
var _tooltip_property = require("../../tooltips/tooltip_property");
var _es_agg_tooltip_property = require("../../tooltips/es_agg_tooltip_property");
var _tile_meta_feature_utils = require("../../util/tile_meta_feature_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Agg without field. Essentially a count-aggregation.
class CountAggField {
  constructor({
    label,
    source,
    origin,
    mask
  }) {
    (0, _defineProperty2.default)(this, "_source", void 0);
    (0, _defineProperty2.default)(this, "_origin", void 0);
    (0, _defineProperty2.default)(this, "_label", void 0);
    (0, _defineProperty2.default)(this, "_mask", void 0);
    this._source = source;
    this._origin = origin;
    this._label = label;
    this._mask = mask;
  }
  supportsFieldMetaFromEs() {
    return false;
  }
  supportsFieldMetaFromLocalData() {
    // Elasticsearch vector tile search API returns meta tiles for aggregation metrics
    return true;
  }
  _getAggType() {
    return _constants.AGG_TYPE.COUNT;
  }
  getSource() {
    return this._source;
  }
  getOrigin() {
    return this._origin;
  }
  getName() {
    return this._source.getAggKey(this._getAggType(), this.getRootName());
  }
  getMbFieldName() {
    return this._source.isMvt() ? '_count' : this.getName();
  }
  getRootName() {
    return '';
  }
  async getLabel() {
    return this._label ? this._label : await this._source.getAggLabel(_constants.AGG_TYPE.COUNT, '');
  }
  isValid() {
    return true;
  }
  async getDataType() {
    return 'number';
  }
  async createTooltipProperty(value) {
    const indexPattern = await this._source.getIndexPattern();
    const tooltipProperty = new _tooltip_property.TooltipProperty(this.getName(), await this.getLabel(), value);
    return new _es_agg_tooltip_property.ESAggTooltipProperty(tooltipProperty, indexPattern, this, this._getAggType(), this._source.getApplyGlobalQuery());
  }
  getValueAggDsl(indexPattern) {
    return null;
  }
  getBucketCount() {
    return 0;
  }
  isCount() {
    return true;
  }
  canValueBeFormatted() {
    return false;
  }
  async getExtendedStatsFieldMetaRequest() {
    return null;
  }
  async getPercentilesFieldMetaRequest(percentiles) {
    return null;
  }
  async getCategoricalFieldMetaRequest(size) {
    return null;
  }
  isEqual(field) {
    return field.getName() === this.getName();
  }
  pluckRangeFromTileMetaFeature(metaFeature) {
    return (0, _tile_meta_feature_utils.getAggRange)(metaFeature, '_count');
  }
  getMask() {
    return this._mask;
  }
}
exports.CountAggField = CountAggField;