"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createMaintenanceWindowRoute = void 0;
var _verify_access_and_context = require("../../../../lib/verify_access_and_context");
var _common = require("../../../../../../common");
var _create = require("../../../../schemas/maintenance_window/internal/request/create");
var _transforms = require("./transforms");
var _transforms2 = require("../transforms");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createMaintenanceWindowRoute = (router, licenseState) => {
  router.post({
    path: _common.INTERNAL_ALERTING_API_MAINTENANCE_WINDOW_PATH,
    validate: {
      body: _create.createBodySchemaV1
    },
    security: {
      authz: {
        requiredPrivileges: [`${_common.MAINTENANCE_WINDOW_API_PRIVILEGES.WRITE_MAINTENANCE_WINDOW}`]
      }
    },
    options: {
      access: 'internal'
    }
  }, router.handleLegacyErrors((0, _verify_access_and_context.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    licenseState.ensureLicenseForMaintenanceWindow();
    const body = req.body;
    const maintenanceWindowClient = (await context.maintenanceWindow).getMaintenanceWindowClient();
    const maintenanceWindow = await maintenanceWindowClient.create({
      data: (0, _transforms.transformCreateBodyV1)(body)
    });
    const response = {
      body: (0, _transforms2.transformInternalMaintenanceWindowToExternalV1)(maintenanceWindow)
    };
    return res.ok(response);
  })));
};
exports.createMaintenanceWindowRoute = createMaintenanceWindowRoute;