"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformUpdateBody = void 0;
var _schedule = require("../../../../../schemas/schedule");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 *  This function converts from the external, human readable, Maintenance Window creation/POST
 *  type expected by the public APIs, to the internal type used by the client.
 */
const transformUpdateBody = updateBody => {
  var _updateBody$scope, _updateBody$schedule, _customSchedule, _customSchedule2;
  const kql = updateBody === null || updateBody === void 0 ? void 0 : (_updateBody$scope = updateBody.scope) === null || _updateBody$scope === void 0 ? void 0 : _updateBody$scope.alerting.query.kql;
  let customSchedule;
  if ((_updateBody$schedule = updateBody.schedule) !== null && _updateBody$schedule !== void 0 && _updateBody$schedule.custom) {
    customSchedule = (0, _schedule.transformCustomScheduleToRRule)(updateBody.schedule.custom);
  }
  return {
    ...(updateBody.title && {
      title: updateBody.title
    }),
    ...(updateBody.enabled !== undefined && {
      enabled: updateBody.enabled
    }),
    ...(((_customSchedule = customSchedule) === null || _customSchedule === void 0 ? void 0 : _customSchedule.duration) && {
      duration: customSchedule.duration
    }),
    ...(((_customSchedule2 = customSchedule) === null || _customSchedule2 === void 0 ? void 0 : _customSchedule2.rRule) && {
      rRule: customSchedule.rRule
    }),
    ...(kql && {
      scopedQuery: {
        kql,
        filters: []
      }
    })
  };
};
exports.transformUpdateBody = transformUpdateBody;