"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MaintenanceWindowsPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _maintenance_window_feature = require("./maintenance_window_feature");
var _saved_objects = require("./saved_objects");
var _events_generation_task = require("./tasks/events_generation_task");
var _lib = require("./lib");
var _maintenance_window_client_factory = require("./maintenance_window_client_factory");
var _routes = require("./routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class MaintenanceWindowsPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "licenseState", null);
    (0, _defineProperty2.default)(this, "maintenanceWindowClientFactory", void 0);
    this.logger = initializerContext.logger.get();
    this.config = this.config = initializerContext.config.get();
    this.maintenanceWindowClientFactory = new _maintenance_window_client_factory.MaintenanceWindowClientFactory();
  }
  setup(core, plugins) {
    this.licenseState = new _lib.LicenseState(plugins.licensing.license$);
    core.capabilities.registerProvider(() => {
      return {
        management: {
          insightsAndAlerting: {
            maintenanceWindows: true
          }
        }
      };
    });
    plugins.features.registerKibanaFeature(_maintenance_window_feature.maintenanceWindowFeature);
    (0, _saved_objects.registerSavedObject)(core.savedObjects, this.logger);
    (0, _events_generation_task.initializeMaintenanceWindowEventsGenerator)(this.logger, plugins.taskManager, core.getStartServices);
    core.http.registerRouteHandlerContext('maintenanceWindow', this.createRouteHandlerContext(core));
    const router = core.http.createRouter();
    (0, _routes.defineRoutes)({
      router,
      licenseState: this.licenseState,
      maintenanceWindowsConfig: this.config
    });
    return {};
  }
  start(core, plugins) {
    const {
      maintenanceWindowClientFactory
    } = this;
    maintenanceWindowClientFactory.initialize({
      logger: this.logger,
      savedObjectsService: core.savedObjects,
      securityService: core.security,
      uiSettings: core.uiSettings
    });
    const getMaintenanceWindowClientWithAuth = request => {
      return maintenanceWindowClientFactory.createWithAuthorization(request);
    };
    const getMaintenanceWindowClientWithoutAuth = request => {
      return maintenanceWindowClientFactory.createWithoutAuthorization(request);
    };
    const getMaintenanceWindowClientInternal = request => {
      return maintenanceWindowClientFactory.createInternal(request);
    };
    (0, _events_generation_task.scheduleMaintenanceWindowEventsGenerator)(this.logger, plugins.taskManager).catch(() => {});
    return {
      getMaintenanceWindowClientWithAuth,
      getMaintenanceWindowClientWithoutAuth,
      getMaintenanceWindowClientInternal
    };
  }
  createRouteHandlerContext(core) {
    const {
      maintenanceWindowClientFactory
    } = this;
    return async function maintenanceWindowsRouteHandlerContext(context, request) {
      return {
        getMaintenanceWindowClient: () => {
          return maintenanceWindowClientFactory.createWithAuthorization(request);
        }
      };
    };
  }
  stop() {
    if (this.licenseState) {
      this.licenseState.clean();
    }
  }
}
exports.MaintenanceWindowsPlugin = MaintenanceWindowsPlugin;