"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getActiveMaintenanceWindows = getActiveMaintenanceWindows;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _esQuery = require("@kbn/es-query");
var _transforms = require("../../transforms");
var _data = require("../../../data");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getActiveMaintenanceWindows(context, cacheIntervalMs) {
  const {
    savedObjectsClient,
    logger
  } = context;
  const startDate = new Date();
  const startDateISO = startDate.toISOString();
  let eventsKuery;
  if (cacheIntervalMs) {
    // add offset to startDate
    const startDateWithCacheOffset = new Date(startDate.getTime() + cacheIntervalMs);
    const startDateWithCacheOffsetISO = startDateWithCacheOffset.toISOString();
    eventsKuery = _esQuery.nodeBuilder.or([_esQuery.nodeBuilder.is('maintenance-window.attributes.events', startDateISO), _esQuery.nodeBuilder.is('maintenance-window.attributes.events', startDateWithCacheOffsetISO)]);
  } else {
    eventsKuery = _esQuery.nodeBuilder.is('maintenance-window.attributes.events', startDateISO);
  }
  const filter = _esQuery.nodeBuilder.and([eventsKuery, _esQuery.nodeBuilder.is('maintenance-window.attributes.enabled', 'true')]);
  try {
    const {
      saved_objects: savedObjects
    } = await (0, _data.findMaintenanceWindowSo)({
      savedObjectsClient,
      savedObjectsFindOptions: {
        filter
      }
    });
    return savedObjects.map(savedObject => {
      return (0, _transforms.transformMaintenanceWindowAttributesToMaintenanceWindow)({
        attributes: savedObject.attributes,
        id: savedObject.id
      });
    });
  } catch (e) {
    const errorMessage = `Failed to find active maintenance window by interval, Error: ${e}`;
    logger.error(errorMessage);
    throw _boom.default.boomify(e, {
      message: errorMessage
    });
  }
}