/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements.
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */(()=>{var e,t={809:(e,t,i)=>{"use strict";i.d(t,{H:()=>n});var s=i(8);const n={settings:{"pipeline.workers":s.i18n.translate("xpack.logstash.workersTooltip",{defaultMessage:"The number of workers that will, in parallel, execute the filter and output stages of the pipeline. If you find that events are backing up, or that the CPU is not saturated, consider increasing this number to better utilize machine processing power.\n\nDefault value: Number of the host’s CPU cores"}),"pipeline.batch.size":s.i18n.translate("xpack.logstash.pipelineBatchSizeTooltip",{defaultMessage:"The maximum number of events an individual worker thread will collect from inputs before attempting to execute its filters and outputs. Larger batch sizes are generally more efficient, but come at the cost of increased memory overhead. You may have to increase the JVM heap size by setting the LS_HEAP_SIZE variable to effectively use the option.\n\nDefault value: 125"}),"pipeline.batch.delay":s.i18n.translate("xpack.logstash.pipelineBatchDelayTooltip",{defaultMessage:"When creating pipeline event batches, how long in milliseconds to wait for each event before dispatching an undersized batch to pipeline workers.\n\nDefault value: 50ms"}),"queue.type":s.i18n.translate("xpack.logstash.queueTypeTooltip",{defaultMessage:"The internal queuing model to use for event buffering. Specify memory for in-memory based queuing, or persisted for disk-based ACKed queueing\n\nDefault value: memory"}),"queue.max_bytes":s.i18n.translate("xpack.logstash.queueMaxBytesTooltip",{defaultMessage:"The total capacity of the queue in number of bytes. Make sure the capacity of your disk drive is greater than the value you specify here.\n\nDefault value: 1024mb (1g)"}),"queue.checkpoint.writes":s.i18n.translate("xpack.logstash.queueCheckpointWritesTooltip",{defaultMessage:"The maximum number of written events before forcing a checkpoint when persistent queues are enabled. Specify 0 to set this value to unlimited.\n\nDefault value: 1024"})}}},11:(e,t,i)=>{"use strict";i.r(t),i.d(t,{plugin:()=>l});var s=i(915),n=i(8),r=i(190),a=i(770),o=i(873);class LogstashPlugin{constructor(e){(0,s.default)(this,"isServerless",void 0),(0,s.default)(this,"licenseSubscription",void 0),(0,s.default)(this,"capabilities$",new r.Subject),this.isServerless="serverless"===e.env.packageInfo.buildFlavor}setup(e,t){const s=t.licensing.license$.pipe((0,r.map)((e=>new o.eQ(e)))),l=n.i18n.translate("xpack.logstash.managementSection.pipelinesTitle",{defaultMessage:"Logstash Pipelines"}),c=t.management.sections.section.ingest.registerApp({id:"pipelines",title:l,order:1,mount:async n=>{const[r]=await e.getStartServices(),{renderApp:a}=await i.e(625).then(i.bind(i,625)),o="monitoring"in t,{docTitle:c}=r.chrome;c.change(l);const u=await a(r,n,o,s,this.isServerless);return()=>{c.reset(),u()}}});this.licenseSubscription=(0,r.combineLatest)([s,this.capabilities$]).subscribe((([e,i])=>{const s=e.enableLinks&&!0===i.management.ingest.pipelines;s?c.enable():c.disable(),t.home&&s&&(0,a.once)((()=>{t.home.featureCatalogue.register({id:"management_logstash",title:n.i18n.translate("xpack.logstash.homeFeature.logstashPipelinesTitle",{defaultMessage:"Logstash Pipelines"}),description:n.i18n.translate("xpack.logstash.homeFeature.logstashPipelinesDescription",{defaultMessage:"Create, delete, update, and clone data ingestion pipelines."}),icon:"pipelineApp",path:"/app/management/ingest/pipelines",showOnHomePage:!1,category:"admin"})}))}))}start(e){this.capabilities$.next(e.application.capabilities)}stop(){this.licenseSubscription&&this.licenseSubscription.unsubscribe()}}const l=e=>new LogstashPlugin(e)},516:(e,t,i)=>{"use strict";i.d(t,{$:()=>Pipeline});var s=i(915),n=i(770);const r={"pipeline.workers":null,"pipeline.batch.size":125,"pipeline.batch.delay":50,"queue.type":"memory","queue.max_bytes.number":1,"queue.max_bytes.units":"gb","queue.checkpoint.writes":1024};class Pipeline{constructor(e=void 0){(0,s.default)(this,"isEqualTo",(e=>{const t={...this},i={...e};return(0,n.isEqual)(t,i)})),this.id=(0,n.get)(e,"id"),this.description=(0,n.get)(e,"description",""),this.pipeline=(0,n.get)(e,"pipeline","input {\n}\nfilter {\n}\noutput {\n}"),this.username=(0,n.get)(e,"username"),this.settings=(0,n.defaultsDeep)((0,n.get)(e,"settings",{}),r)}get clone(){return new Pipeline({...(0,n.omit)(this,["id","username"])})}get upstreamJSON(){const e=this.settings,t=(0,n.get)(e,"queue.max_bytes.number"),i=(0,n.get)(e,"queue.max_bytes.units"),s={...e};return t&&i&&(delete s["queue.max_bytes.number"],delete s["queue.max_bytes.units"],s["queue.max_bytes"]=`${t}${i}`),{description:this.description,pipeline:this.pipeline,username:this.username,settings:s}}static fromUpstreamJSON(e){const t=e.settings,i=(0,n.get)(t,"queue.max_bytes","").match(/(\d+)(\w+)/);if(Array.isArray(i)&&3===i.length){const e=i[1],s=i[2];e&&s&&(delete t["queue.max_bytes"],t["queue.max_bytes.number"]=parseInt(e),t["queue.max_bytes.units"]=s)}return new Pipeline({id:e.id,description:e.description,pipeline:e.pipeline,username:e.username,settings:t})}}},873:(e,t,i)=>{"use strict";i.d(t,{GE:()=>ClusterService,eQ:()=>LogstashLicenseService,GL:()=>MonitoringService,Mk:()=>PipelineService,xR:()=>PipelinesService});const s="/api/logstash";i(809);const n="centralized_configuration_management",r="file_or_command_line_interface_or_pipelines_yml";var a=i(770);class Cluster{constructor(e){this.uuid=(0,a.get)(e,"uuid")}static fromUpstreamJSON(e){return new Cluster({uuid:e.uuid})}}class ClusterService{constructor(e){this.http=e}loadCluster(){return this.http.get(`${s}/cluster`).then((e=>{if(e)return Cluster.fromUpstreamJSON(e.cluster)}))}isClusterInfoAvailable(){return this.loadCluster().then((e=>Boolean(e))).catch((()=>!1))}}var o=i(8);class LogstashLicenseService{constructor(e,t,i){this.license=e,this.navigateToApp=t,this.toasts=i}get enableLinks(){return this.calculated.enableLinks}get isAvailable(){return this.calculated.isAvailable}get isReadOnly(){return this.calculated.isReadOnly}get message(){return this.calculated.message}get isSecurityEnabled(){return this.license.getFeature("security").isEnabled}checkValidity(){return new Promise(((e,t)=>this.isAvailable?e():t()))}get calculated(){if(!this.license)throw new Error("No license available!");return this.isSecurityEnabled?this.license.hasAtLeast("standard")?this.license.isActive?{isAvailable:!0,enableLinks:!0,isReadOnly:!1}:{isAvailable:!0,enableLinks:!0,isReadonly:!0,message:o.i18n.translate("xpack.logstash.managementSection.pipelineCrudOperationsNotAllowedDescription",{defaultMessage:"You cannot edit, create, or delete your Logstash pipelines because your {licenseType} license has expired.",values:{licenseType:this.license.type}})}:{isAvailable:!1,enableLinks:!1,isReadOnly:!1,message:o.i18n.translate("xpack.logstash.managementSection.licenseDoesNotSupportDescription",{defaultMessage:"Your {licenseType} license does not support Logstash pipeline management features. Please upgrade your license.",values:{licenseType:this.license.type}})}:{isAvailable:!1,enableLinks:!1,isReadOnly:!1,message:o.i18n.translate("xpack.logstash.managementSection.enableSecurityDescription",{defaultMessage:"Security must be enabled in order to use Logstash pipeline management features. Please set xpack.security.enabled: true in your elasticsearch.yml."})}}}const l=__kbnSharedDeps__.Moment;var c=i.n(l);class PipelineListItem{constructor(e){var t;this.id=e.id,this.origin=e.origin,this.description=e.description,this.username=e.username,e.lastModified&&(this.lastModified=(t=e.lastModified)?c()(t):null,this.lastModifiedHumanized=(0,a.upperFirst)(this.lastModified.fromNow()))}get searchValue(){return e=["id"],(0,a.values)((0,a.pick)(this,e)).join("\n");var e}get isCentrallyManaged(){return this.origin===n}static fromUpstreamJSON(e){const t=(0,a.pick)(e,["id","description","username"]);return t.origin=n,t.lastModified=e.last_modified,new PipelineListItem(t)}static fromUpstreamMonitoringJSON(e){const t=(0,a.pick)(e,["id"]);return t.origin=r,new PipelineListItem(t)}}class MonitoringService{constructor(e,t,i){this.http=e,this._isMonitoringEnabled=t,this.clusterService=i}isMonitoringEnabled(){return this._isMonitoringEnabled}getPipelineList(){return this.isMonitoringEnabled()?this.clusterService.loadCluster().then((e=>{const t=`/api/monitoring/v1/clusters/${e.uuid}/logstash/pipeline_ids`,i=c().utc(),s=JSON.stringify({timeRange:{max:i.toISOString(),min:i.subtract(30,"seconds").toISOString()}});return this.http.post(t,{body:s})})).then((e=>e.map((e=>PipelineListItem.fromUpstreamMonitoringJSON(e))))).catch((()=>[])):Promise.resolve([])}}var u=i(516);class PipelineService{constructor(e,t){this.http=e,this.pipelinesService=t}loadPipeline(e){return this.http.get(`${s}/pipeline/${e}`).then((e=>u.$.fromUpstreamJSON(e)))}savePipeline(e){return this.http.put(`${s}/pipeline/${e.id}`,{body:JSON.stringify(e.upstreamJSON)}).catch((e=>{throw e.message}))}deletePipeline(e){return this.http.delete(`${s}/pipeline/${e}`).then((()=>this.pipelinesService.addToRecentlyDeleted(e))).catch((e=>{throw e.message}))}}const p="xpack.logstash.recentlyDeletedPipelines";class PipelinesService{constructor(e,t){this.http=e,this.monitoringService=t}getPipelineList(){return Promise.all([this.getManagementPipelineList(),this.getMonitoringPipelineList()]).then((([e,t])=>{const i=Date.now(),s=t.map((e=>e.id));this.getRecentlyDeleted().forEach((e=>{i-e.deletedOn<3e4||s.includes(e.id)||this.removeFromRecentlyDeleted(e.id)}));const n=e.map((e=>e.id));return e.concat(t.filter((e=>!n.includes(e.id)&&!this.isRecentlyDeleted(e.id))))}))}getManagementPipelineList(){return this.http.get(`${s}/pipelines`).then((e=>e.pipelines.map((e=>PipelineListItem.fromUpstreamJSON(e)))))}getMonitoringPipelineList(){return this.monitoringService.getPipelineList()}deletePipelines(e){const t=JSON.stringify({pipelineIds:e});return this.http.post(`${s}/pipelines/delete`,{body:t}).then((t=>(this.addToRecentlyDeleted(...e),t.results)))}addToRecentlyDeleted(...e){const t=this.getRecentlyDeleted(),i=t.map((e=>e.id));e.forEach((e=>{i.includes(e)||t.push({id:e,deletedOn:Date.now()})})),this.setRecentlyDeleted(t)}removeFromRecentlyDeleted(...e){const t=this.getRecentlyDeleted().filter((t=>!e.includes(t.id)));this.setRecentlyDeleted(t)}isRecentlyDeleted(e){return this.getRecentlyDeleted().map((e=>e.id)).includes(e)}getRecentlyDeleted(){const e=window.localStorage.getItem(p);return e?JSON.parse(e):[]}setRecentlyDeleted(e){window.localStorage.setItem(p,JSON.stringify(e))}}},344:(e,t,i)=>{i.p=window.__kbnPublicPath__.logstash},915:(e,t,i)=>{e.exports=i(497)(67493)},319:e=>{"use strict";e.exports=__kbnSharedDeps__.ElasticEui},791:e=>{"use strict";e.exports=__kbnSharedDeps__.EmotionReact},424:e=>{"use strict";e.exports=__kbnSharedDeps__.KbnCodeEditor},8:e=>{"use strict";e.exports=__kbnSharedDeps__.KbnI18n},879:e=>{"use strict";e.exports=__kbnSharedDeps__.KbnI18nReact},482:e=>{"use strict";e.exports=__kbnSharedDeps__.KbnReactKibanaContextRender},193:e=>{"use strict";e.exports=__kbnSharedDeps__.KbnSharedUxRouter},770:e=>{"use strict";e.exports=__kbnSharedDeps__.Lodash},286:e=>{"use strict";e.exports=__kbnSharedDeps__.React},874:e=>{"use strict";e.exports=__kbnSharedDeps__.ReactDom},493:e=>{"use strict";e.exports=__kbnSharedDeps__.ReactRouterDom},190:e=>{"use strict";e.exports=__kbnSharedDeps__.Rxjs},941:e=>{"use strict";e.exports=__kbnSharedDeps__.TsLib},497:e=>{"use strict";e.exports=__kbnSharedDeps_npm__}},i={};function s(e){var n=i[e];if(void 0!==n)return n.exports;var r=i[e]={exports:{}};return t[e](r,r.exports,s),r.exports}s.m=t,s.n=e=>{var t=e&&e.__esModule?()=>e.default:()=>e;return s.d(t,{a:t}),t},s.d=(e,t)=>{for(var i in t)s.o(t,i)&&!s.o(e,i)&&Object.defineProperty(e,i,{enumerable:!0,get:t[i]})},s.f={},s.e=e=>Promise.all(Object.keys(s.f).reduce(((t,i)=>(s.f[i](e,t),t)),[])),s.u=e=>"logstash.chunk."+e+".js",s.g=function(){if("object"==typeof globalThis)return globalThis;try{return this||new Function("return this")()}catch(e){if("object"==typeof window)return window}}(),s.o=(e,t)=>Object.prototype.hasOwnProperty.call(e,t),e={},s.l=(t,i,n,r)=>{if(e[t])e[t].push(i);else{var a,o;if(void 0!==n)for(var l=document.getElementsByTagName("script"),c=0;c<l.length;c++){var u=l[c];if(u.getAttribute("src")==t){a=u;break}}a||(o=!0,(a=document.createElement("script")).charset="utf-8",a.timeout=120,s.nc&&a.setAttribute("nonce",s.nc),a.src=t),e[t]=[i];var p=(i,s)=>{a.onerror=a.onload=null,clearTimeout(d);var n=e[t];if(delete e[t],a.parentNode&&a.parentNode.removeChild(a),n&&n.forEach((e=>e(s))),i)return i(s)},d=setTimeout(p.bind(null,void 0,{type:"timeout",target:a}),12e4);a.onerror=p.bind(null,a.onerror),a.onload=p.bind(null,a.onload),o&&document.head.appendChild(a)}},s.r=e=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},(()=>{var e;s.g.importScripts&&(e=s.g.location+"");var t=s.g.document;if(!e&&t&&(t.currentScript&&"SCRIPT"===t.currentScript.tagName.toUpperCase()&&(e=t.currentScript.src),!e)){var i=t.getElementsByTagName("script");if(i.length)for(var n=i.length-1;n>-1&&(!e||!/^http(s?):/.test(e));)e=i[n--].src}if(!e)throw new Error("Automatic publicPath is not supported in this browser");e=e.replace(/#.*$/,"").replace(/\?.*$/,"").replace(/\/[^\/]+$/,"/"),s.p=e})(),(()=>{var e={890:0};s.f.j=(t,i)=>{var n=s.o(e,t)?e[t]:void 0;if(0!==n)if(n)i.push(n[2]);else{var r=new Promise(((i,s)=>n=e[t]=[i,s]));i.push(n[2]=r);var a=s.p+s.u(t),o=new Error;s.l(a,(i=>{if(s.o(e,t)&&(0!==(n=e[t])&&(e[t]=void 0),n)){var r=i&&("load"===i.type?"missing":i.type),a=i&&i.target&&i.target.src;o.message="Loading chunk "+t+" failed.\n("+r+": "+a+")",o.name="ChunkLoadError",o.type=r,o.request=a,n[1](o)}}),"chunk-"+t,t)}};var t=(t,i)=>{var n,r,[a,o,l]=i,c=0;if(a.some((t=>0!==e[t]))){for(n in o)s.o(o,n)&&(s.m[n]=o[n]);l&&l(s)}for(t&&t(i);c<a.length;c++)r=a[c],s.o(e,r)&&e[r]&&e[r][0](),e[r]=0},i=self.logstash_bundle_jsonpfunction=self.logstash_bundle_jsonpfunction||[];i.forEach(t.bind(null,0)),i.push=t.bind(null,i.push.bind(i))})(),s(344),__kbnBundles__.define("plugin/logstash/public",s,11)})();