"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitoringService = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _constants = require("../../../common/constants");
var _pipeline_list_item = require("../../models/pipeline_list_item");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class MonitoringService {
  constructor(http, isMonitoringEnabled, clusterService) {
    this.http = http;
    this._isMonitoringEnabled = isMonitoringEnabled;
    this.clusterService = clusterService;
  }
  isMonitoringEnabled() {
    return this._isMonitoringEnabled;
  }
  getPipelineList() {
    if (!this.isMonitoringEnabled()) {
      return Promise.resolve([]);
    }
    return this.clusterService.loadCluster().then(cluster => {
      // This API call should live within the Monitoring plugin
      // https://github.com/elastic/kibana/issues/63931
      const url = `${_constants.ROUTES.MONITORING_API_ROOT}/v1/clusters/${cluster.uuid}/logstash/pipeline_ids`;
      const now = _moment.default.utc();
      const body = JSON.stringify({
        timeRange: {
          max: now.toISOString(),
          min: now.subtract(_constants.MONITORING.ACTIVE_PIPELINE_RANGE_S, 'seconds').toISOString()
        }
      });
      return this.http.post(url, {
        body
      });
    }).then(response => response.map(pipeline => _pipeline_list_item.PipelineListItem.fromUpstreamMonitoringJSON(pipeline))).catch(() => []);
  }
}
exports.MonitoringService = MonitoringService;