"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerServices = registerServices;
var _log_sources_service = require("./log_sources_service");
var _log_data_service = require("./log_data_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerServices(params) {
  const logSourcesService = (0, _log_sources_service.createLogSourcesService)(params);
  const logDataService = (0, _log_data_service.createLogDataService)({
    ...params,
    logSourcesService
  });
  return {
    logSourcesService,
    logDataService
  };
}