"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.exportExceptionsRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _securitysolutionListConstants = require("@kbn/securitysolution-list-constants");
var _zodHelpers = require("@kbn/zod-helpers");
var _api = require("@kbn/securitysolution-exceptions-common/api");
var _constants = require("@kbn/security-solution-features/constants");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const exportExceptionsRoute = router => {
  router.versioned.post({
    access: 'public',
    path: `${_securitysolutionListConstants.EXCEPTION_LIST_URL}/_export`,
    security: {
      authz: {
        requiredPrivileges: [_constants.LISTS_API_READ]
      }
    }
  }).addVersion({
    validate: {
      request: {
        query: (0, _zodHelpers.buildRouteValidationWithZod)(_api.ExportExceptionListRequestQuery)
      }
    },
    version: '2023-10-31'
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    try {
      const {
        id,
        list_id: listId,
        namespace_type: namespaceType,
        include_expired_exceptions: includeExpiredExceptionsString
      } = request.query;
      const exceptionListsClient = await (0, _utils.getExceptionListClient)(context);

      // Defaults to including expired exceptions if query param is not present
      const includeExpiredExceptions = includeExpiredExceptionsString !== undefined ? includeExpiredExceptionsString === 'true' : true;
      const exportContent = await exceptionListsClient.exportExceptionListAndItems({
        id,
        includeExpiredExceptions,
        listId,
        namespaceType
      });
      if (exportContent == null) {
        return siemResponse.error({
          body: `exception list with list_id: ${listId} or id: ${id} does not exist`,
          statusCode: 400
        });
      }
      return response.ok({
        body: `${exportContent.exportData}${JSON.stringify(exportContent.exportDetails)}\n`,
        headers: {
          'Content-Disposition': `attachment; filename="${listId}"`,
          'Content-Type': 'application/ndjson'
        }
      });
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return siemResponse.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.exportExceptionsRoute = exportExceptionsRoute;