"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteEndpointListItemRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _securitysolutionListConstants = require("@kbn/securitysolution-list-constants");
var _zodHelpers = require("@kbn/zod-helpers");
var _api = require("@kbn/securitysolution-endpoint-exceptions-common/api");
var _constants = require("@kbn/security-solution-features/constants");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deleteEndpointListItemRoute = router => {
  router.versioned.delete({
    access: 'public',
    path: _securitysolutionListConstants.ENDPOINT_LIST_ITEM_URL,
    security: {
      authz: {
        requiredPrivileges: [_constants.LISTS_API_ALL]
      }
    }
  }).addVersion({
    validate: {
      request: {
        query: (0, _zodHelpers.buildRouteValidationWithZod)(_api.DeleteEndpointListItemRequestQuery)
      }
    },
    version: '2023-10-31'
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    try {
      const exceptionLists = await (0, _utils.getExceptionListClient)(context);
      const {
        item_id: itemId,
        id
      } = request.query;
      if (itemId == null && id == null) {
        return siemResponse.error({
          body: 'Either "item_id" or "id" needs to be defined in the request',
          statusCode: 400
        });
      } else {
        const deleted = await exceptionLists.deleteEndpointListItem({
          id,
          itemId
        });
        if (deleted == null) {
          return siemResponse.error({
            body: (0, _utils.getErrorMessageExceptionListItem)({
              id,
              itemId
            }),
            statusCode: 404
          });
        } else {
          return response.ok({
            body: _api.DeleteEndpointListItemResponse.parse(deleted)
          });
        }
      }
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return siemResponse.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.deleteEndpointListItemRoute = deleteEndpointListItemRoute;