"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BreadcrumbService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class BreadcrumbService {
  constructor() {
    (0, _defineProperty2.default)(this, "breadcrumbs", {
      dashboard: [],
      upload: []
    });
    (0, _defineProperty2.default)(this, "setBreadcrumbsHandler", void 0);
  }
  setup(setBreadcrumbsHandler) {
    this.setBreadcrumbsHandler = setBreadcrumbsHandler;

    // Home and sections
    this.breadcrumbs.dashboard = [{
      text: _i18n.i18n.translate('xpack.licenseMgmt.dashboard.breadcrumb', {
        defaultMessage: 'License management'
      }),
      href: `/`
    }];
    this.breadcrumbs.upload = [...this.breadcrumbs.dashboard, {
      text: _i18n.i18n.translate('xpack.licenseMgmt.upload.breadcrumb', {
        defaultMessage: 'Upload'
      })
    }];
  }
  setBreadcrumbs(type) {
    if (!this.setBreadcrumbsHandler) {
      throw new Error(`BreadcrumbService#setup() must be called first!`);
    }
    const newBreadcrumbs = this.breadcrumbs[type] ? [...this.breadcrumbs[type]] : [...this.breadcrumbs.home];

    // Pop off last breadcrumb
    const lastBreadcrumb = newBreadcrumbs.pop();

    // Put last breadcrumb back without href
    newBreadcrumbs.push({
      ...lastBreadcrumb,
      href: undefined
    });
    this.setBreadcrumbsHandler(newBreadcrumbs);
  }
}
exports.BreadcrumbService = BreadcrumbService;