"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultReferenceLineColor = void 0;
exports.getAccessorColorConfigs = getAccessorColorConfigs;
exports.getAssignedColorConfig = getAssignedColorConfig;
exports.getColorAssignments = getColorAssignments;
var _lodash = require("lodash");
var _uiTheme = require("@kbn/ui-theme");
var _eventAnnotationCommon = require("@kbn/event-annotation-common");
var _state_helpers = require("./state_helpers");
var _visualization_helpers = require("./visualization_helpers");
var _helpers = require("./annotations/helpers");
var _reference_line_helpers = require("./reference_line_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isPrimitive = value => value != null && typeof value !== 'object';
const defaultReferenceLineColor = exports.defaultReferenceLineColor = _uiTheme.euiLightVars.euiColorDarkShade;
function getColorAssignments(layers, data, formatFactory) {
  const layersPerPalette = {};
  layers.filter(_visualization_helpers.isDataLayer).forEach(layer => {
    var _layer$palette;
    const palette = ((_layer$palette = layer.palette) === null || _layer$palette === void 0 ? void 0 : _layer$palette.name) || 'default';
    if (!layersPerPalette[palette]) {
      layersPerPalette[palette] = [];
    }
    layersPerPalette[palette].push(layer);
  });
  return (0, _lodash.mapValues)(layersPerPalette, paletteLayers => {
    const seriesPerLayer = paletteLayers.map((layer, layerIndex) => {
      var _data$tables$layer$la;
      if (layer.collapseFn || !layer.splitAccessor) {
        return {
          numberOfSeries: layer.accessors.length,
          splits: []
        };
      }
      const splitAccessor = layer.splitAccessor;
      const column = (_data$tables$layer$la = data.tables[layer.layerId]) === null || _data$tables$layer$la === void 0 ? void 0 : _data$tables$layer$la.columns.find(({
        id
      }) => id === splitAccessor);
      const columnFormatter = column && formatFactory(column.meta.params);
      const splits = !column || !data.tables[layer.layerId] ? [] : (0, _lodash.uniq)(data.tables[layer.layerId].rows.map(row => {
        let value = row[splitAccessor];
        if (value && !isPrimitive(value)) {
          var _columnFormatter$conv;
          value = (_columnFormatter$conv = columnFormatter === null || columnFormatter === void 0 ? void 0 : columnFormatter.convert(value)) !== null && _columnFormatter$conv !== void 0 ? _columnFormatter$conv : value;
        } else {
          value = String(value);
        }
        return value;
      }));
      return {
        numberOfSeries: (splits.length || 1) * layer.accessors.length,
        splits
      };
    });
    const totalSeriesCount = seriesPerLayer.reduce((sum, perLayer) => sum + perLayer.numberOfSeries, 0);
    return {
      totalSeriesCount,
      getRank(sortedLayer, seriesKey, yAccessor) {
        const layerIndex = paletteLayers.findIndex(l => sortedLayer.layerId === l.layerId);
        const currentSeriesPerLayer = seriesPerLayer[layerIndex];
        const splitRank = currentSeriesPerLayer.splits.indexOf(seriesKey);
        return (layerIndex === 0 ? 0 : seriesPerLayer.slice(0, layerIndex).reduce((sum, perLayer) => sum + perLayer.numberOfSeries, 0)) + (sortedLayer.splitAccessor && splitRank !== -1 ? splitRank * sortedLayer.accessors.length : 0) + sortedLayer.accessors.indexOf(yAccessor);
      }
    };
  });
}
function getDisabledConfig(accessor) {
  return {
    columnId: accessor,
    triggerIconType: 'disabled'
  };
}
function getAssignedColorConfig(layer, accessor, colorAssignments, frame, paletteService) {
  var _colorAssignments$cur;
  if ((0, _visualization_helpers.isReferenceLayer)(layer)) {
    return (0, _reference_line_helpers.getSingleColorConfig)(accessor);
  }
  if ((0, _visualization_helpers.isAnnotationsLayer)(layer)) {
    const annotation = layer.annotations.find(a => a.id === accessor);
    return {
      columnId: accessor,
      triggerIconType: annotation !== null && annotation !== void 0 && annotation.isHidden ? 'invisible' : 'color',
      color: (0, _eventAnnotationCommon.isRangeAnnotationConfig)(annotation) ? _eventAnnotationCommon.defaultAnnotationRangeColor : _eventAnnotationCommon.defaultAnnotationColor
    };
  }
  const layerContainsSplits = (0, _visualization_helpers.isDataLayer)(layer) && !layer.collapseFn && layer.splitAccessor;
  const currentPalette = layer.palette || {
    type: 'palette',
    name: 'default'
  };
  const totalSeriesCount = (_colorAssignments$cur = colorAssignments[currentPalette.name]) === null || _colorAssignments$cur === void 0 ? void 0 : _colorAssignments$cur.totalSeriesCount;
  if (layerContainsSplits) {
    return getDisabledConfig(accessor);
  }
  const columnToLabel = (0, _state_helpers.getColumnToLabelMap)(layer, frame.datasourceLayers[layer.layerId]);
  const rank = colorAssignments[currentPalette.name].getRank(layer, columnToLabel[accessor] || accessor, accessor);
  const assignedColor = totalSeriesCount != null ? paletteService.get(currentPalette.name).getCategoricalColor([{
    name: columnToLabel[accessor] || accessor,
    rankAtDepth: rank,
    totalSeriesAtDepth: totalSeriesCount
  }], {
    maxDepth: 1,
    totalSeries: totalSeriesCount
  }, currentPalette.params) : undefined;
  return {
    columnId: accessor,
    triggerIconType: assignedColor ? 'color' : 'disabled',
    color: assignedColor !== null && assignedColor !== void 0 ? assignedColor : undefined
  };
}
function getAccessorColorConfigs(colorAssignments, frame, layer, paletteService) {
  if ((0, _visualization_helpers.isReferenceLayer)(layer)) {
    return (0, _reference_line_helpers.getReferenceLineAccessorColorConfig)(layer);
  }
  if ((0, _visualization_helpers.isAnnotationsLayer)(layer)) {
    return (0, _helpers.getAnnotationsAccessorColorConfig)(layer);
  }
  const layerContainsSplits = !layer.collapseFn && layer.splitAccessor;
  return layer.accessors.map(accessor => {
    var _layer$yConfig;
    if (layerContainsSplits) {
      return getDisabledConfig(accessor);
    }
    const currentYConfig = (_layer$yConfig = layer.yConfig) === null || _layer$yConfig === void 0 ? void 0 : _layer$yConfig.find(yConfig => yConfig.forAccessor === accessor);
    if (currentYConfig !== null && currentYConfig !== void 0 && currentYConfig.color) {
      return {
        columnId: accessor,
        triggerIconType: 'color',
        color: currentYConfig.color
      };
    }
    return getAssignedColorConfig(layer, accessor, colorAssignments, frame, paletteService);
  });
}