"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSuggestions = void 0;
var _chartIcons = require("@kbn/chart-icons");
var _public = require("@kbn/expression-xy-plugin/public");
var _visualization = require("./visualization");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_BUCKETED_COLUMNS = 1;
const MAX_METRIC_COLUMNS = 2; // primary and secondary metric

const hasLayerMismatch = (keptLayerIds, table) => keptLayerIds.length > 1 || keptLayerIds.length && table.layerId !== keptLayerIds[0];
const getSuggestions = ({
  table,
  state,
  keptLayerIds
}) => {
  var _metricColumns$, _metricColumns$2, _bucketedColumns$;
  const isActive = Boolean(state);
  const metricColumns = table.columns.filter(({
    operation
  }) => _visualization.supportedDataTypes.has(operation.dataType) && !operation.isBucketed);
  const bucketedColumns = table.columns.filter(({
    operation
  }) => operation.isBucketed);
  const unsupportedColumns = table.columns.filter(({
    operation
  }) => !_visualization.supportedDataTypes.has(operation.dataType) && !operation.isBucketed);
  const couldNeverFit = unsupportedColumns.length || bucketedColumns.length > MAX_BUCKETED_COLUMNS || metricColumns.length > MAX_METRIC_COLUMNS;
  if (!table.columns.length || hasLayerMismatch(keptLayerIds, table) || couldNeverFit ||
  // dragging the first field
  isActive && table.changeType === 'initial' && metricColumns.length && bucketedColumns.length || isActive && table.changeType === 'unchanged') {
    return [];
  }
  const baseSuggestion = {
    state: {
      ...state,
      layerId: table.layerId,
      layerType: _public.LayerTypes.DATA
    },
    title: ((_metricColumns$ = metricColumns[0]) === null || _metricColumns$ === void 0 ? void 0 : _metricColumns$.operation.label) || _visualization.metricLabel,
    previewIcon: _chartIcons.IconChartMetric,
    score: 0.5,
    hide: !!bucketedColumns.length
  };
  const accessorMappings = {
    metricAccessor: (_metricColumns$2 = metricColumns[0]) === null || _metricColumns$2 === void 0 ? void 0 : _metricColumns$2.columnId,
    breakdownByAccessor: (_bucketedColumns$ = bucketedColumns[0]) === null || _bucketedColumns$ === void 0 ? void 0 : _bucketedColumns$.columnId
  };
  baseSuggestion.score = Number((baseSuggestion.score + 0.01 * Object.values(accessorMappings).filter(Boolean).length).toFixed(2));
  const suggestion = {
    ...baseSuggestion,
    state: {
      ...baseSuggestion.state,
      ...accessorMappings,
      secondaryMetricAccessor: undefined,
      maxAccessor: undefined
    }
  };
  return [suggestion];
};
exports.getSuggestions = getSuggestions;