"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlyoutToolbar = FlyoutToolbar;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _chartIcons = require("@kbn/chart-icons");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _flyout_container = require("./flyout_container");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/shared_components/flyout_toolbar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const baseToolbarOptions = [{
  id: 'legend',
  label: _i18n.i18n.translate('xpack.lens.flyoutToolbar.legend.title', {
    defaultMessage: 'Legend'
  }),
  iconType: _chartIcons.EuiIconLegend,
  toolTipContent: _i18n.i18n.translate('xpack.lens.flyoutToolbar.legend.tooltip', {
    defaultMessage: 'Legend'
  })
}, {
  id: 'style',
  label: _i18n.i18n.translate('xpack.lens.flyoutToolbar.style.title', {
    defaultMessage: 'Style'
  }),
  iconType: 'brush',
  toolTipContent: _i18n.i18n.translate('xpack.lens.flyoutToolbar.style.tooltip', {
    defaultMessage: 'Style'
  })
}
// {
//   id: 'filters',
//   label: i18n.translate('xpack.lens.flyoutToolbar.filtersTitle', {
//     defaultMessage: 'Filters',
//   }),
//   iconType: 'filter',
//   toolTipContent: i18n.translate('xpack.lens.flyoutToolbar.filtersOptionTooltip', {
//     defaultMessage: 'Filters',
//   }),
// },
];
function FlyoutToolbar({
  contentMap,
  isInlineEditing = false,
  ...flyoutContentProps
}) {
  var _toolbarOptions$find;
  const [isFlyoutVisible, setFlyoutVisible] = (0, _react.useState)(false);
  const [idSelected, setIdSelected] = (0, _react.useState)('');

  // Filter out toolbar options that don't have corresponding content components
  const toolbarOptions = (0, _react.useMemo)(() => baseToolbarOptions.filter(option => !!contentMap[option.id]), [contentMap]);
  const flyoutToolbarStyles = (0, _use_memo_css.useMemoCss)(styles);
  const flyoutTitle = idSelected ? ((_toolbarOptions$find = toolbarOptions.find(toolbarOption => toolbarOption.id === idSelected)) === null || _toolbarOptions$find === void 0 ? void 0 : _toolbarOptions$find.label) || '' : '';
  const handleOptionChange = id => {
    setIdSelected(id);
    setFlyoutVisible(true);
  };
  const FlyoutContent = idSelected ? contentMap[idSelected] : null;
  return /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
        // NOTE: Override euiAccordion styles added in LensConfigurationFlyout
        .euiAccordion {
          display: block;
        }
      `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: _i18n.i18n.translate('xpack.lens.flyoutToolbar.buttonGroup.legend', {
      defaultMessage: 'Toolbar options'
    }),
    options: toolbarOptions,
    onChange: handleOptionChange,
    idSelected: idSelected,
    isIconOnly: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_flyout_container.FlyoutContainer, {
    isFullscreen: false,
    label: flyoutTitle,
    isInlineEditing: isInlineEditing,
    isOpen: isFlyoutVisible,
    handleClose: () => {
      setIdSelected('');
      setFlyoutVisible(false);
    },
    overrideContainerCss: flyoutToolbarStyles.dialog,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 7
    }
  }, FlyoutContent ? /*#__PURE__*/_react.default.createElement("div", {
    id: idSelected,
    css: flyoutToolbarStyles.flyoutContent,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(FlyoutContent, (0, _extends2.default)({}, flyoutContentProps, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 13
    }
  }))) : null));
}
const styles = {
  dialog: ({
    euiTheme
  }) => (0, _react2.css)`
      z-index: ${euiTheme.levels.menu};
    `,
  flyoutContent: ({
    euiTheme
  }) => (0, _react2.css)({
    padding: euiTheme.size.base,
    height: '100%'
  })
};