"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDispatcher = useDispatcher;
exports.useMessages = useMessages;
var _lodash = require("lodash");
var _react = require("react");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _public = require("@kbn/kibana-utils-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This hooks known how to extract message based on types for the UI
 */
function useMessages({
  messages$
}) {
  const latestMessages = (0, _presentationPublishing.useStateFromPublishingSubject)(messages$);
  return (0, _react.useMemo)(() => (0, _lodash.partition)(latestMessages, ({
    severity
  }) => severity !== 'info'), [latestMessages]);
}

/**
 * This hook is responsible to emit the render start/complete JS event
 * The render error is handled by the data_loader itself when updating the blocking errors
 */
function useDispatcher(hasRendered, api) {
  const rootRef = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    var _api$blockingError$;
    if (!rootRef.current || (_api$blockingError$ = api.blockingError$) !== null && _api$blockingError$ !== void 0 && _api$blockingError$.getValue()) {
      return;
    }
    if (hasRendered) {
      (0, _public.dispatchRenderComplete)(rootRef.current);
    } else {
      (0, _public.dispatchRenderStart)(rootRef.current);
    }
  }, [hasRendered, api.blockingError$, rootRef]);
  return rootRef;
}