"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.showMemoizedErrorNotification = exports.initMemoizedErrorNotification = void 0;
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/kibana-utils-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const [getMemoizedErrorNotification, setMemoizedErrorNotification] = (0, _common.createGetterSetter)('MemoizedErrorNotification', false);
const memoizedErrorNotificationFactory = coreStart => {
  const showedErrors = new Map();
  return error => {
    const {
      message
    } = error;
    if (message) {
      if (!showedErrors.has(message)) {
        coreStart.notifications.toasts.addError(error, {
          title: _i18n.i18n.translate('xpack.lens.uiErrors.unexpectedError', {
            defaultMessage: 'An unexpected error occurred.'
          })
        });
        showedErrors.set(message, true);
      }
    }
  };
};
const showMemoizedErrorNotification = error => {
  var _getMemoizedErrorNoti;
  return (_getMemoizedErrorNoti = getMemoizedErrorNotification()) === null || _getMemoizedErrorNoti === void 0 ? void 0 : _getMemoizedErrorNoti(error);
};
exports.showMemoizedErrorNotification = showMemoizedErrorNotification;
const initMemoizedErrorNotification = coreStart => {
  setMemoizedErrorNotification(memoizedErrorNotificationFactory(coreStart));
};
exports.initMemoizedErrorNotification = initMemoizedErrorNotification;